/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.FargatePlatformVersion;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.ITaskDefinition;
import software.amazon.awscdk.services.events.targets.$Module;
import software.amazon.awscdk.services.events.targets.ContainerOverride;
import software.amazon.awscdk.services.events.targets.EcsTaskProps;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-events-targets.EcsTaskProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EcsTaskProps
extends JsiiSerializable {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public ITaskDefinition getTaskDefinition();

    @Nullable
    default public List<ContainerOverride> getContainerOverrides() {
        return null;
    }

    @Nullable
    default public FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Deprecated
    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public List<ISecurityGroup> getSecurityGroups() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnetSelection() {
        return null;
    }

    @Nullable
    default public Number getTaskCount() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsTaskProps> {
        private ICluster cluster;
        private ITaskDefinition taskDefinition;
        private List<ContainerOverride> containerOverrides;
        private FargatePlatformVersion platformVersion;
        private IRole role;
        private ISecurityGroup securityGroup;
        private List<ISecurityGroup> securityGroups;
        private SubnetSelection subnetSelection;
        private Number taskCount;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder taskDefinition(ITaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder containerOverrides(List<? extends ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder platformVersion(FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        @Deprecated
        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder taskCount(Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public EcsTaskProps build() {
            return new Jsii.Proxy(this.cluster, this.taskDefinition, this.containerOverrides, this.platformVersion, this.role, this.securityGroup, this.securityGroups, this.subnetSelection, this.taskCount);
        }
    }
}

