package software.amazon.awscdk.services.events.targets;

/**
 * Properties for an AwsApi target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.787Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.AwsApiProps")
@software.amazon.jsii.Jsii.Proxy(AwsApiProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.AwsApiInput {

    /**
     * The IAM policy statement to allow the API call.
     * <p>
     * Use only if
     * resource restriction is needed.
     * <p>
     * Default: - extract the permission from the API call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.iam.PolicyStatement getPolicyStatement() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.iam.PolicyStatement policyStatement;
        private java.lang.String action;
        private java.lang.String service;
        private java.lang.String apiVersion;
        private java.lang.String catchErrorPattern;
        private java.lang.Object parameters;

        /**
         * Sets the value of {@link AwsApiProps#getPolicyStatement}
         * @param policyStatement The IAM policy statement to allow the API call.
         *                        Use only if
         *                        resource restriction is needed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatement(software.amazon.awscdk.services.iam.PolicyStatement policyStatement) {
            this.policyStatement = policyStatement;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiProps#getAction}
         * @param action The service action to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiProps#getService}
         * @param service The service to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiProps#getApiVersion}
         * @param apiVersion API version to use for the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiVersion(java.lang.String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiProps#getCatchErrorPattern}
         * @param catchErrorPattern The regex pattern to use to catch API errors.
         *                          The <code>code</code> property of the
         *                          <code>Error</code> object will be tested against this pattern. If there is a match an
         *                          error will not be thrown.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catchErrorPattern(java.lang.String catchErrorPattern) {
            this.catchErrorPattern = catchErrorPattern;
            return this;
        }

        /**
         * Sets the value of {@link AwsApiProps#getParameters}
         * @param parameters The parameters for the service action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.lang.Object parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AwsApiProps build() {
            return new Jsii$Proxy(policyStatement, action, service, apiVersion, catchErrorPattern, parameters);
        }
    }

    /**
     * An implementation for {@link AwsApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsApiProps {
        private final software.amazon.awscdk.services.iam.PolicyStatement policyStatement;
        private final java.lang.String action;
        private final java.lang.String service;
        private final java.lang.String apiVersion;
        private final java.lang.String catchErrorPattern;
        private final java.lang.Object parameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyStatement = this.jsiiGet("policyStatement", software.amazon.awscdk.services.iam.PolicyStatement.class);
            this.action = this.jsiiGet("action", java.lang.String.class);
            this.service = this.jsiiGet("service", java.lang.String.class);
            this.apiVersion = this.jsiiGet("apiVersion", java.lang.String.class);
            this.catchErrorPattern = this.jsiiGet("catchErrorPattern", java.lang.String.class);
            this.parameters = this.jsiiGet("parameters", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.iam.PolicyStatement policyStatement, final java.lang.String action, final java.lang.String service, final java.lang.String apiVersion, final java.lang.String catchErrorPattern, final java.lang.Object parameters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyStatement = policyStatement;
            this.action = java.util.Objects.requireNonNull(action, "action is required");
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.apiVersion = apiVersion;
            this.catchErrorPattern = catchErrorPattern;
            this.parameters = parameters;
        }

        @Override
        public software.amazon.awscdk.services.iam.PolicyStatement getPolicyStatement() {
            return this.policyStatement;
        }

        @Override
        public java.lang.String getAction() {
            return this.action;
        }

        @Override
        public java.lang.String getService() {
            return this.service;
        }

        @Override
        public java.lang.String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        public java.lang.String getCatchErrorPattern() {
            return this.catchErrorPattern;
        }

        @Override
        public java.lang.Object getParameters() {
            return this.parameters;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPolicyStatement() != null) {
                data.set("policyStatement", om.valueToTree(this.getPolicyStatement()));
            }
            data.set("action", om.valueToTree(this.getAction()));
            data.set("service", om.valueToTree(this.getService()));
            if (this.getApiVersion() != null) {
                data.set("apiVersion", om.valueToTree(this.getApiVersion()));
            }
            if (this.getCatchErrorPattern() != null) {
                data.set("catchErrorPattern", om.valueToTree(this.getCatchErrorPattern()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events-targets.AwsApiProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsApiProps.Jsii$Proxy that = (AwsApiProps.Jsii$Proxy) o;

            if (this.policyStatement != null ? !this.policyStatement.equals(that.policyStatement) : that.policyStatement != null) return false;
            if (!action.equals(that.action)) return false;
            if (!service.equals(that.service)) return false;
            if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
            if (this.catchErrorPattern != null ? !this.catchErrorPattern.equals(that.catchErrorPattern) : that.catchErrorPattern != null) return false;
            return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
        }

        @Override
        public int hashCode() {
            int result = this.policyStatement != null ? this.policyStatement.hashCode() : 0;
            result = 31 * result + (this.action.hashCode());
            result = 31 * result + (this.service.hashCode());
            result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
            result = 31 * result + (this.catchErrorPattern != null ? this.catchErrorPattern.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            return result;
        }
    }
}
