package software.amazon.awscdk.services.events.targets;

/**
 * Start a CodeBuild build when an AWS CloudWatch events rule is triggered.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.787Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.CodeBuildProject")
public class CodeBuildProject extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected CodeBuildProject(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodeBuildProject(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param project This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeBuildProject(final software.amazon.awscdk.services.codebuild.IProject project, final software.amazon.awscdk.services.events.targets.CodeBuildProjectProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required"), props });
    }

    /**
     * @param project This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodeBuildProject(final software.amazon.awscdk.services.codebuild.IProject project) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(project, "project is required") });
    }

    /**
     * Allows using build projects as event rule targets.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule, final java.lang.String _id) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Allows using build projects as event rule targets.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.CodeBuildProject}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param project This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.codebuild.IProject project) {
            return new Builder(project);
        }

        private final software.amazon.awscdk.services.codebuild.IProject project;
        private software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder props;

        private Builder(final software.amazon.awscdk.services.codebuild.IProject project) {
            this.project = project;
        }

        /**
         * The event to send to CodeBuild.
         * <p>
         * This will be the payload for the StartBuild API.
         * <p>
         * Default: - the entire CloudWatch event
         * <p>
         * @return {@code this}
         * @param event The event to send to CodeBuild. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder event(final software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.props().event(event);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.CodeBuildProject}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.events.targets.CodeBuildProject build() {
            return new software.amazon.awscdk.services.events.targets.CodeBuildProject(
                this.project,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.CodeBuildProjectProps.Builder();
            }
            return this.props;
        }
    }
}
