package software.amazon.awscdk.services.events.targets;

/**
 * Allows the pipeline to be used as a CloudWatch event rule target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.788Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.CodePipeline")
public class CodePipeline extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected CodePipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param pipeline This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodePipeline(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline, final software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(pipeline, "pipeline is required"), options });
    }

    /**
     * @param pipeline This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodePipeline(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(pipeline, "pipeline is required") });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule, final java.lang.String _id) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.CodePipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param pipeline This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
            return new Builder(pipeline);
        }

        private final software.amazon.awscdk.services.codepipeline.IPipeline pipeline;
        private software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
            this.pipeline = pipeline;
        }

        /**
         * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.options().eventRole(eventRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.CodePipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.events.targets.CodePipeline build() {
            return new software.amazon.awscdk.services.events.targets.CodePipeline(
                this.pipeline,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder();
            }
            return this.options;
        }
    }
}
