package software.amazon.awscdk.services.events.targets;

/**
 * Start a task on an ECS cluster.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.788Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.EcsTask")
public class EcsTask extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected EcsTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsTask(final software.amazon.awscdk.services.events.targets.EcsTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Allows using tasks as target of CloudWatch events.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule, final java.lang.String _id) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Allows using tasks as target of CloudWatch events.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.EcsTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.events.targets.EcsTaskProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.events.targets.EcsTaskProps.Builder();
        }

        /**
         * Cluster where service will be deployed.
         * <p>
         * @return {@code this}
         * @param cluster Cluster where service will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * Task Definition of the task that should be started.
         * <p>
         * @return {@code this}
         * @param taskDefinition Task Definition of the task that should be started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.props.taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Container setting overrides.
         * <p>
         * Key is the name of the container to override, value is the
         * values you want to override.
         * <p>
         * @return {@code this}
         * @param containerOverrides Container setting overrides. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerOverrides(final java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides) {
            this.props.containerOverrides(containerOverrides);
            return this;
        }

        /**
         * Existing security group to use for the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: A new security group is created
         * <p>
         * @return {@code this}
         * @param securityGroup Existing security group to use for the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * In what subnets to place the task's ENIs.
         * <p>
         * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * <p>
         * Default: Private subnets
         * <p>
         * @return {@code this}
         * @param subnetSelection In what subnets to place the task's ENIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.props.subnetSelection(subnetSelection);
            return this;
        }

        /**
         * How many tasks should be started when this event is triggered.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param taskCount How many tasks should be started when this event is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(final java.lang.Number taskCount) {
            this.props.taskCount(taskCount);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.EcsTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.events.targets.EcsTask build() {
            return new software.amazon.awscdk.services.events.targets.EcsTask(
                this.props.build()
            );
        }
    }
}
