package software.amazon.awscdk.services.events.targets;

/**
 * Properties to define an ECS Event Task.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.789Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.EcsTaskProps")
@software.amazon.jsii.Jsii.Proxy(EcsTaskProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsTaskProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Cluster where service will be deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ecs.ICluster getCluster();

    /**
     * Task Definition of the task that should be started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition();

    /**
     * Container setting overrides.
     * <p>
     * Key is the name of the container to override, value is the
     * values you want to override.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> getContainerOverrides() {
        return null;
    }

    /**
     * Existing security group to use for the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: A new security group is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * In what subnets to place the task's ENIs.
     * <p>
     * (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
     * <p>
     * Default: Private subnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
        return null;
    }

    /**
     * How many tasks should be started when this event is triggered.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default java.lang.Number getTaskCount() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private java.lang.Number taskCount;

        /**
         * Sets the value of {@link EcsTaskProps#getCluster}
         * @param cluster Cluster where service will be deployed. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getTaskDefinition}
         * @param taskDefinition Task Definition of the task that should be started. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getContainerOverrides}
         * @param containerOverrides Container setting overrides.
         *                           Key is the name of the container to override, value is the
         *                           values you want to override.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerOverrides(java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getSecurityGroup}
         * @param securityGroup Existing security group to use for the task's ENIs.
         *                      (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getSubnetSelection}
         * @param subnetSelection In what subnets to place the task's ENIs.
         *                        (Only applicable in case the TaskDefinition is configured for AwsVpc networking)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetSelection(software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        /**
         * Sets the value of {@link EcsTaskProps#getTaskCount}
         * @param taskCount How many tasks should be started when this event is triggered.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskCount(java.lang.Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsTaskProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public EcsTaskProps build() {
            return new Jsii$Proxy(cluster, taskDefinition, containerOverrides, securityGroup, subnetSelection, taskCount);
        }
    }

    /**
     * An implementation for {@link EcsTaskProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsTaskProps {
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition;
        private final java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection;
        private final java.lang.Number taskCount;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cluster = this.jsiiGet("cluster", software.amazon.awscdk.services.ecs.ICluster.class);
            this.taskDefinition = this.jsiiGet("taskDefinition", software.amazon.awscdk.services.ecs.TaskDefinition.class);
            this.containerOverrides = this.jsiiGet("containerOverrides", java.util.List.class);
            this.securityGroup = this.jsiiGet("securityGroup", software.amazon.awscdk.services.ec2.ISecurityGroup.class);
            this.subnetSelection = this.jsiiGet("subnetSelection", software.amazon.awscdk.services.ec2.SubnetSelection.class);
            this.taskCount = this.jsiiGet("taskCount", java.lang.Number.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.ecs.ICluster cluster, final software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition, final java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> containerOverrides, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.ec2.SubnetSelection subnetSelection, final java.lang.Number taskCount) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cluster = java.util.Objects.requireNonNull(cluster, "cluster is required");
            this.taskDefinition = java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required");
            this.containerOverrides = containerOverrides;
            this.securityGroup = securityGroup;
            this.subnetSelection = subnetSelection;
            this.taskCount = taskCount;
        }

        @Override
        public software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.events.targets.ContainerOverride> getContainerOverrides() {
            return this.containerOverrides;
        }

        @Override
        public software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public software.amazon.awscdk.services.ec2.SubnetSelection getSubnetSelection() {
            return this.subnetSelection;
        }

        @Override
        public java.lang.Number getTaskCount() {
            return this.taskCount;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cluster", om.valueToTree(this.getCluster()));
            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));
            if (this.getContainerOverrides() != null) {
                data.set("containerOverrides", om.valueToTree(this.getContainerOverrides()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSubnetSelection() != null) {
                data.set("subnetSelection", om.valueToTree(this.getSubnetSelection()));
            }
            if (this.getTaskCount() != null) {
                data.set("taskCount", om.valueToTree(this.getTaskCount()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-events-targets.EcsTaskProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsTaskProps.Jsii$Proxy that = (EcsTaskProps.Jsii$Proxy) o;

            if (!cluster.equals(that.cluster)) return false;
            if (!taskDefinition.equals(that.taskDefinition)) return false;
            if (this.containerOverrides != null ? !this.containerOverrides.equals(that.containerOverrides) : that.containerOverrides != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.subnetSelection != null ? !this.subnetSelection.equals(that.subnetSelection) : that.subnetSelection != null) return false;
            return this.taskCount != null ? this.taskCount.equals(that.taskCount) : that.taskCount == null;
        }

        @Override
        public int hashCode() {
            int result = this.cluster.hashCode();
            result = 31 * result + (this.taskDefinition.hashCode());
            result = 31 * result + (this.containerOverrides != null ? this.containerOverrides.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.subnetSelection != null ? this.subnetSelection.hashCode() : 0);
            result = 31 * result + (this.taskCount != null ? this.taskCount.hashCode() : 0);
            return result;
        }
    }
}
