package software.amazon.awscdk.services.events.targets;

/**
 * Use a StepFunctions state machine as a target for AWS CloudWatch event rules.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.795Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.SfnStateMachine")
public class SfnStateMachine extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected SfnStateMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SfnStateMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param machine This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SfnStateMachine(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine, final software.amazon.awscdk.services.events.targets.SfnStateMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(machine, "machine is required"), props });
    }

    /**
     * @param machine This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SfnStateMachine(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(machine, "machine is required") });
    }

    /**
     * Returns a properties that are used in an Rule to trigger this State Machine.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule, final java.lang.String _id) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns a properties that are used in an Rule to trigger this State Machine.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sns-permissions
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule _rule) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.stepfunctions.IStateMachine getMachine() {
        return this.jsiiGet("machine", software.amazon.awscdk.services.stepfunctions.IStateMachine.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.SfnStateMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param machine This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
            return new Builder(machine);
        }

        private final software.amazon.awscdk.services.stepfunctions.IStateMachine machine;
        private software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder props;

        private Builder(final software.amazon.awscdk.services.stepfunctions.IStateMachine machine) {
            this.machine = machine;
        }

        /**
         * The input to the state machine execution.
         * <p>
         * Default: the entire CloudWatch event
         * <p>
         * @return {@code this}
         * @param input The input to the state machine execution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.events.RuleTargetInput input) {
            this.props().input(input);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.SfnStateMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.events.targets.SfnStateMachine build() {
            return new software.amazon.awscdk.services.events.targets.SfnStateMachine(
                this.machine,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.SfnStateMachineProps.Builder();
            }
            return this.props;
        }
    }
}
