package software.amazon.awscdk.services.events.targets;

/**
 * Use an SQS Queue as a target for AWS CloudWatch event rules.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // publish to an SQS queue every time code is committed
 * // to a CodeCommit repository
 * repository.onCommit(new SqsQueue(queue));}</pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.21.2 (build 4370756)", date = "2020-01-23T18:16:59.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.events.targets.$Module.class, fqn = "@aws-cdk/aws-events-targets.SqsQueue")
public class SqsQueue extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected SqsQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsQueue(final software.amazon.awscdk.services.sqs.IQueue queue, final software.amazon.awscdk.services.events.targets.SqsQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsQueue(final software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this SQS queue as a result from a CloudWatch event.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sqs-permissions
     * @param rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule rule, final java.lang.String _id) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required"), _id });
    }

    /**
     * Returns a RuleTarget that can be used to trigger this SQS queue as a result from a CloudWatch event.
     * <p>
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/resource-based-policies-cwe.html#sqs-permissions
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public software.amazon.awscdk.services.events.RuleTargetConfig bind(final software.amazon.awscdk.services.events.IRule rule) {
        return this.jsiiCall("bind", software.amazon.awscdk.services.events.RuleTargetConfig.class, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public software.amazon.awscdk.services.sqs.IQueue getQueue() {
        return this.jsiiGet("queue", software.amazon.awscdk.services.sqs.IQueue.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.SqsQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * The message to send to the queue.
         * <p>
         * Must be a valid JSON text passed to the target queue.
         * <p>
         * Default: the entire CloudWatch event
         * <p>
         * @return {@code this}
         * @param message The message to send to the queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(final software.amazon.awscdk.services.events.RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        /**
         * Message Group ID for messages sent to this queue.
         * <p>
         * Required for FIFO queues, leave empty for regular queues.
         * <p>
         * Default: - no message group ID (regular queue)
         * <p>
         * @return {@code this}
         * @param messageGroupId Message Group ID for messages sent to this queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder messageGroupId(final java.lang.String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.SqsQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.events.targets.SqsQueue build() {
            return new software.amazon.awscdk.services.events.targets.SqsQueue(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.events.targets.SqsQueueProps.Builder();
            }
            return this.props;
        }
    }
}
