/**
 * <h1>Event Targets for AWS CloudWatch Events</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="Stability: Stable" src="https://img.shields.io/badge/stability-Stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library contains integration classes to send AWS CloudWatch Events to any
 * number of supported AWS Services. Instances of these classes should be passed
 * to the <code>rule.addTarget()</code> method.
 * <p>
 * Currently supported are:
 * <p>
 * <ul>
 * <li>Start a CodeBuild build</li>
 * <li>Start a CodePipeline pipeline</li>
 * <li>Run an ECS task</li>
 * <li>Invoke a Lambda function</li>
 * <li>Publish a message to an SNS topic</li>
 * <li>Send a message to an SQS queue</li>
 * <li>Start a StepFunctions state machine</li>
 * <li>Make an AWS API call</li>
 * </ul>
 * <p>
 * See the README of the <code>&#64;aws-cdk/aws-events</code> library for more information on
 * CloudWatch Events.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.events.targets;
