/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.events.targets.;
import software.amazon.awscdk.services.events.targets.ContainerOverride;
import software.amazon.awscdk.services.events.targets.EcsTaskProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-events-targets.EcsTaskProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EcsTaskProps
extends JsiiSerializable {
    @NotNull
    public ICluster getCluster();

    @NotNull
    public TaskDefinition getTaskDefinition();

    @Nullable
    default public List<ContainerOverride> getContainerOverrides() {
        return null;
    }

    @Nullable
    default public ISecurityGroup getSecurityGroup() {
        return null;
    }

    @Nullable
    default public SubnetSelection getSubnetSelection() {
        return null;
    }

    @Nullable
    default public Number getTaskCount() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ICluster cluster;
        private TaskDefinition taskDefinition;
        private List<ContainerOverride> containerOverrides;
        private ISecurityGroup securityGroup;
        private SubnetSelection subnetSelection;
        private Number taskCount;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder containerOverrides(List<ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder taskCount(Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public EcsTaskProps build() {
            return new Jsii.Proxy(this.cluster, this.taskDefinition, this.containerOverrides, this.securityGroup, this.subnetSelection, this.taskCount, null);
        }
    }
}

