/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.events.IRule;
import software.amazon.awscdk.services.events.IRuleTarget;
import software.amazon.awscdk.services.events.RuleTargetConfig;
import software.amazon.awscdk.services.events.RuleTargetInput;
import software.amazon.awscdk.services.events.targets.;
import software.amazon.awscdk.services.events.targets.SqsQueueProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-events-targets.SqsQueue")
public class SqsQueue
extends JsiiObject
implements IRuleTarget {
    protected SqsQueue(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsQueue(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SqsQueue(@NotNull IQueue queue, @Nullable SqsQueueProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), props});
    }

    public SqsQueue(@NotNull IQueue queue) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required")});
    }

    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule, @Nullable String _id) {
        return (RuleTargetConfig)this.jsiiCall("bind", RuleTargetConfig.class, new Object[]{Objects.requireNonNull(rule, "rule is required"), _id});
    }

    @NotNull
    public RuleTargetConfig bind(@NotNull IRule rule) {
        return (RuleTargetConfig)this.jsiiCall("bind", RuleTargetConfig.class, new Object[]{Objects.requireNonNull(rule, "rule is required")});
    }

    @NotNull
    public IQueue getQueue() {
        return (IQueue)this.jsiiGet("queue", IQueue.class);
    }

    public static final class Builder {
        private final IQueue queue;
        private SqsQueueProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
        }

        public Builder message(RuleTargetInput message) {
            this.props().message(message);
            return this;
        }

        public Builder messageGroupId(String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        public SqsQueue build() {
            return new SqsQueue(this.queue, this.props != null ? this.props.build() : null);
        }

        private SqsQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new SqsQueueProps.Builder();
            }
            return this.props;
        }
    }
}

