/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.events.targets;

import java.util.List;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.ecs.ICluster;
import software.amazon.awscdk.services.ecs.TaskDefinition;
import software.amazon.awscdk.services.events.targets.ContainerOverride;
import software.amazon.awscdk.services.events.targets.EcsTaskProps;
import software.amazon.jsii.JsiiSerializable;

public interface EcsTaskProps
extends JsiiSerializable {
    public ICluster getCluster();

    public TaskDefinition getTaskDefinition();

    public List<ContainerOverride> getContainerOverrides();

    public ISecurityGroup getSecurityGroup();

    public SubnetSelection getSubnetSelection();

    public Number getTaskCount();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ICluster cluster;
        private TaskDefinition taskDefinition;
        private List<ContainerOverride> containerOverrides;
        private ISecurityGroup securityGroup;
        private SubnetSelection subnetSelection;
        private Number taskCount;

        public Builder cluster(ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public Builder containerOverrides(List<ContainerOverride> containerOverrides) {
            this.containerOverrides = containerOverrides;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder subnetSelection(SubnetSelection subnetSelection) {
            this.subnetSelection = subnetSelection;
            return this;
        }

        public Builder taskCount(Number taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public EcsTaskProps build() {
            return new Jsii.Proxy(this.cluster, this.taskDefinition, this.containerOverrides, this.securityGroup, this.subnetSelection, this.taskCount, null);
        }
    }
}

