package software.amazon.awscdk.services.fsx;

/**
 * The different kinds of file system deployments used by Lustre.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.SCRATCH_2).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:41.669Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.fsx.$Module.class, fqn = "@aws-cdk/aws-fsx.LustreDeploymentType")
public enum LustreDeploymentType {
    /**
     * Original type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_1,
    /**
     * Newer type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     * Provides better support for spiky workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_2,
    /**
     * Long term storage.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_1,
    /**
     * Newer type of long term storage with higher throughput tiers.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_2,
}
