package software.amazon.awscdk.services.gamelift;

/**
 * Properties for defining a `CfnFleet`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnFleetProps cfnFleetProps = CfnFleetProps.builder()
 *         .buildId("buildId")
 *         .certificateConfiguration(CertificateConfigurationProperty.builder()
 *                 .certificateType("certificateType")
 *                 .build())
 *         .description("description")
 *         .desiredEc2Instances(123)
 *         .ec2InboundPermissions(List.of(IpPermissionProperty.builder()
 *                 .fromPort(123)
 *                 .ipRange("ipRange")
 *                 .protocol("protocol")
 *                 .toPort(123)
 *                 .build()))
 *         .ec2InstanceType("ec2InstanceType")
 *         .fleetType("fleetType")
 *         .instanceRoleArn("instanceRoleArn")
 *         .locations(List.of(LocationConfigurationProperty.builder()
 *                 .location("location")
 *                 // the properties below are optional
 *                 .locationCapacity(LocationCapacityProperty.builder()
 *                         .desiredEc2Instances(123)
 *                         .maxSize(123)
 *                         .minSize(123)
 *                         .build())
 *                 .build()))
 *         .maxSize(123)
 *         .metricGroups(List.of("metricGroups"))
 *         .minSize(123)
 *         .name("name")
 *         .newGameSessionProtectionPolicy("newGameSessionProtectionPolicy")
 *         .peerVpcAwsAccountId("peerVpcAwsAccountId")
 *         .peerVpcId("peerVpcId")
 *         .resourceCreationLimitPolicy(ResourceCreationLimitPolicyProperty.builder()
 *                 .newGameSessionsPerCreator(123)
 *                 .policyPeriodInMinutes(123)
 *                 .build())
 *         .runtimeConfiguration(RuntimeConfigurationProperty.builder()
 *                 .gameSessionActivationTimeoutSeconds(123)
 *                 .maxConcurrentGameSessionActivations(123)
 *                 .serverProcesses(List.of(ServerProcessProperty.builder()
 *                         .concurrentExecutions(123)
 *                         .launchPath("launchPath")
 *                         // the properties below are optional
 *                         .parameters("parameters")
 *                         .build()))
 *                 .build())
 *         .scriptId("scriptId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:35.025Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.gamelift.$Module.class, fqn = "@aws-cdk/aws-gamelift.CfnFleetProps")
@software.amazon.jsii.Jsii.Proxy(CfnFleetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFleetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A unique identifier for a build to be deployed on the new fleet.
     * <p>
     * If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBuildId() {
        return null;
    }

    /**
     * Prompts GameLift to generate a TLS/SSL certificate for the fleet.
     * <p>
     * GameLift uses the certificates to encrypt traffic between game clients and the game servers running on GameLift. By default, the <code>CertificateConfiguration</code> is <code>DISABLED</code> . You can't change this property after you create the fleet.
     * <p>
     * AWS Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months, consider using fleet aliases for a smooth transition.
     * <p>
     * <blockquote>
     * <p>
     * ACM isn't available in all AWS regions. A fleet creation request with certificate generation enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the <em>AWS Certificate Manager User Guide</em> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificateConfiguration() {
        return null;
    }

    /**
     * A description for the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The number of EC2 instances that you want this fleet to host.
     * <p>
     * When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDesiredEc2Instances() {
        return null;
    }

    /**
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
     * <p>
     * If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEc2InboundPermissions() {
        return null;
    }

    /**
     * The GameLift-supported Amazon EC2 instance type to use for all fleet instances.
     * <p>
     * Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="https://docs.aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2InstanceType() {
        return null;
    }

    /**
     * Indicates whether to use On-Demand or Spot instances for this fleet.
     * <p>
     * By default, this property is set to <code>ON_DEMAND</code> . Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . This property cannot be changed after the fleet is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFleetType() {
        return null;
    }

    /**
     * A unique identifier for an IAM role that manages access to your AWS services.
     * <p>
     * With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://docs.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console . Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">Access external resources from a game server</a> . This property cannot be changed after the fleet is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceRoleArn() {
        return null;
    }

    /**
     * A set of remote locations to deploy additional instances to and manage as part of the fleet.
     * <p>
     * This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code> . To create a fleet with instances in the home Region only, omit this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocations() {
        return null;
    }

    /**
     * The maximum number of instances that are allowed in the specified fleet location.
     * <p>
     * If this parameter is not set, the default is 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxSize() {
        return null;
    }

    /**
     * The name of an AWS CloudWatch metric group to add this fleet to.
     * <p>
     * A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMetricGroups() {
        return null;
    }

    /**
     * The minimum number of instances that are allowed in the specified fleet location.
     * <p>
     * If this parameter is not set, the default is 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return null;
    }

    /**
     * A descriptive label that is associated with a fleet.
     * <p>
     * Fleet names do not need to be unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The status of termination protection for active game sessions on the fleet.
     * <p>
     * By default, this property is set to <code>NoProtection</code> .
     * <p>
     * <ul>
     * <li><em>NoProtection</em> - Game sessions can be terminated during active gameplay as a result of a scale-down event.</li>
     * <li><em>FullProtection</em> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNewGameSessionProtectionPolicy() {
        return null;
    }

    /**
     * Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC.
     * <p>
     * You can find your account ID in the AWS Management Console under account settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerVpcAwsAccountId() {
        return null;
    }

    /**
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet.
     * <p>
     * The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://docs.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console . Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPeerVpcId() {
        return null;
    }

    /**
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getResourceCreationLimitPolicy() {
        return null;
    }

    /**
     * Instructions for how to launch and maintain server processes on instances in the fleet.
     * <p>
     * The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
     * <p>
     * <blockquote>
     * <p>
     * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> , which are still supported for backward compatibility.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfiguration() {
        return null;
    }

    /**
     * The unique identifier for a Realtime configuration script to be deployed on fleet instances.
     * <p>
     * You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.
     * <p>
     * <blockquote>
     * <p>
     * You can't use the <code>!Ref</code> command to reference a script created with a CloudFormation template for the fleet property <code>ScriptId</code> . Instead, use <code>Fn::GetAtt Script.Arn</code> or <code>Fn::GetAtt Script.Id</code> to retrieve either of these properties as input for <code>ScriptId</code> . Alternatively, enter a <code>ScriptId</code> string manually.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScriptId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFleetProps> {
        java.lang.String buildId;
        java.lang.Object certificateConfiguration;
        java.lang.String description;
        java.lang.Number desiredEc2Instances;
        java.lang.Object ec2InboundPermissions;
        java.lang.String ec2InstanceType;
        java.lang.String fleetType;
        java.lang.String instanceRoleArn;
        java.lang.Object locations;
        java.lang.Number maxSize;
        java.util.List<java.lang.String> metricGroups;
        java.lang.Number minSize;
        java.lang.String name;
        java.lang.String newGameSessionProtectionPolicy;
        java.lang.String peerVpcAwsAccountId;
        java.lang.String peerVpcId;
        java.lang.Object resourceCreationLimitPolicy;
        java.lang.Object runtimeConfiguration;
        java.lang.String scriptId;

        /**
         * Sets the value of {@link CfnFleetProps#getBuildId}
         * @param buildId A unique identifier for a build to be deployed on the new fleet.
         *                If you are deploying the fleet with a custom game build, you must specify this property. The build must have been successfully uploaded to Amazon GameLift and be in a <code>READY</code> status. This fleet setting cannot be changed once the fleet is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildId(java.lang.String buildId) {
            this.buildId = buildId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getCertificateConfiguration}
         * @param certificateConfiguration Prompts GameLift to generate a TLS/SSL certificate for the fleet.
         *                                 GameLift uses the certificates to encrypt traffic between game clients and the game servers running on GameLift. By default, the <code>CertificateConfiguration</code> is <code>DISABLED</code> . You can't change this property after you create the fleet.
         *                                 <p>
         *                                 AWS Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months, consider using fleet aliases for a smooth transition.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 ACM isn't available in all AWS regions. A fleet creation request with certificate generation enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the <em>AWS Certificate Manager User Guide</em> .
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateConfiguration(software.amazon.awscdk.core.IResolvable certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getCertificateConfiguration}
         * @param certificateConfiguration Prompts GameLift to generate a TLS/SSL certificate for the fleet.
         *                                 GameLift uses the certificates to encrypt traffic between game clients and the game servers running on GameLift. By default, the <code>CertificateConfiguration</code> is <code>DISABLED</code> . You can't change this property after you create the fleet.
         *                                 <p>
         *                                 AWS Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months, consider using fleet aliases for a smooth transition.
         *                                 <p>
         *                                 <blockquote>
         *                                 <p>
         *                                 ACM isn't available in all AWS regions. A fleet creation request with certificate generation enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the <em>AWS Certificate Manager User Guide</em> .
         *                                 <p>
         *                                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateConfiguration(software.amazon.awscdk.services.gamelift.CfnFleet.CertificateConfigurationProperty certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDescription}
         * @param description A description for the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getDesiredEc2Instances}
         * @param desiredEc2Instances The number of EC2 instances that you want this fleet to host.
         *                            When creating a new fleet, GameLift automatically sets this value to "1" and initiates a single instance. Once the fleet is active, update this value to trigger GameLift to add or remove instances from the fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredEc2Instances(java.lang.Number desiredEc2Instances) {
            this.desiredEc2Instances = desiredEc2Instances;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEc2InboundPermissions}
         * @param ec2InboundPermissions The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
         *                              If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InboundPermissions(software.amazon.awscdk.core.IResolvable ec2InboundPermissions) {
            this.ec2InboundPermissions = ec2InboundPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEc2InboundPermissions}
         * @param ec2InboundPermissions The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
         *                              If the fleet is hosting a custom game build, this property must be set before players can connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InboundPermissions(java.util.List<? extends java.lang.Object> ec2InboundPermissions) {
            this.ec2InboundPermissions = ec2InboundPermissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getEc2InstanceType}
         * @param ec2InstanceType The GameLift-supported Amazon EC2 instance type to use for all fleet instances.
         *                        Instance type determines the computing resources that will be used to host your game servers, including CPU, memory, storage, and networking capacity. See <a href="https://docs.aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2InstanceType(java.lang.String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getFleetType}
         * @param fleetType Indicates whether to use On-Demand or Spot instances for this fleet.
         *                  By default, this property is set to <code>ON_DEMAND</code> . Learn more about when to use <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot">On-Demand versus Spot Instances</a> . This property cannot be changed after the fleet is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fleetType(java.lang.String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getInstanceRoleArn}
         * @param instanceRoleArn A unique identifier for an IAM role that manages access to your AWS services.
         *                        With an instance role ARN set, any application that runs on an instance in this fleet can assume the role, including install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the <a href="https://docs.aws.amazon.com/iam/">IAM dashboard</a> in the AWS Management Console . Learn more about using on-box credentials for your game servers at <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">Access external resources from a game server</a> . This property cannot be changed after the fleet is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRoleArn(java.lang.String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getLocations}
         * @param locations A set of remote locations to deploy additional instances to and manage as part of the fleet.
         *                  This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code> . To create a fleet with instances in the home Region only, omit this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(software.amazon.awscdk.core.IResolvable locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getLocations}
         * @param locations A set of remote locations to deploy additional instances to and manage as part of the fleet.
         *                  This parameter can only be used when creating fleets in AWS Regions that support multiple locations. You can add any GameLift-supported AWS Region as a remote location, in the form of an AWS Region code such as <code>us-west-2</code> . To create a fleet with instances in the home Region only, omit this parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder locations(java.util.List<? extends java.lang.Object> locations) {
            this.locations = locations;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMaxSize}
         * @param maxSize The maximum number of instances that are allowed in the specified fleet location.
         *                If this parameter is not set, the default is 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(java.lang.Number maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMetricGroups}
         * @param metricGroups The name of an AWS CloudWatch metric group to add this fleet to.
         *                     A metric group is used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to create a new metric group. A fleet can be included in only one metric group at a time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricGroups(java.util.List<java.lang.String> metricGroups) {
            this.metricGroups = metricGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getMinSize}
         * @param minSize The minimum number of instances that are allowed in the specified fleet location.
         *                If this parameter is not set, the default is 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getName}
         * @param name A descriptive label that is associated with a fleet.
         *             Fleet names do not need to be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getNewGameSessionProtectionPolicy}
         * @param newGameSessionProtectionPolicy The status of termination protection for active game sessions on the fleet.
         *                                       By default, this property is set to <code>NoProtection</code> .
         *                                       <p>
         *                                       <ul>
         *                                       <li><em>NoProtection</em> - Game sessions can be terminated during active gameplay as a result of a scale-down event.</li>
         *                                       <li><em>FullProtection</em> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down event.</li>
         *                                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder newGameSessionProtectionPolicy(java.lang.String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getPeerVpcAwsAccountId}
         * @param peerVpcAwsAccountId Used when peering your GameLift fleet with a VPC, the unique identifier for the AWS account that owns the VPC.
         *                            You can find your account ID in the AWS Management Console under account settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerVpcAwsAccountId(java.lang.String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getPeerVpcId}
         * @param peerVpcId A unique identifier for a VPC with resources to be accessed by your GameLift fleet.
         *                  The VPC must be in the same Region as your fleet. To look up a VPC ID, use the <a href="https://docs.aws.amazon.com/vpc/">VPC Dashboard</a> in the AWS Management Console . Learn more about VPC peering in <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift Fleets</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder peerVpcId(java.lang.String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getResourceCreationLimitPolicy}
         * @param resourceCreationLimitPolicy A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCreationLimitPolicy(software.amazon.awscdk.core.IResolvable resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getResourceCreationLimitPolicy}
         * @param resourceCreationLimitPolicy A policy that limits the number of game sessions that an individual player can create on instances in this fleet within a specified span of time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceCreationLimitPolicy(software.amazon.awscdk.services.gamelift.CfnFleet.ResourceCreationLimitPolicyProperty resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getRuntimeConfiguration}
         * @param runtimeConfiguration Instructions for how to launch and maintain server processes on instances in the fleet.
         *                             The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> , which are still supported for backward compatibility.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(software.amazon.awscdk.core.IResolvable runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getRuntimeConfiguration}
         * @param runtimeConfiguration Instructions for how to launch and maintain server processes on instances in the fleet.
         *                             The runtime configuration defines one or more server process configurations, each identifying a build executable or Realtime script file and the number of processes of that type to run concurrently.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code> , which are still supported for backward compatibility.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfiguration(software.amazon.awscdk.services.gamelift.CfnFleet.RuntimeConfigurationProperty runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnFleetProps#getScriptId}
         * @param scriptId The unique identifier for a Realtime configuration script to be deployed on fleet instances.
         *                 You can use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property cannot be changed later.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 You can't use the <code>!Ref</code> command to reference a script created with a CloudFormation template for the fleet property <code>ScriptId</code> . Instead, use <code>Fn::GetAtt Script.Arn</code> or <code>Fn::GetAtt Script.Id</code> to retrieve either of these properties as input for <code>ScriptId</code> . Alternatively, enter a <code>ScriptId</code> string manually.
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scriptId(java.lang.String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFleetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFleetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFleetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFleetProps {
        private final java.lang.String buildId;
        private final java.lang.Object certificateConfiguration;
        private final java.lang.String description;
        private final java.lang.Number desiredEc2Instances;
        private final java.lang.Object ec2InboundPermissions;
        private final java.lang.String ec2InstanceType;
        private final java.lang.String fleetType;
        private final java.lang.String instanceRoleArn;
        private final java.lang.Object locations;
        private final java.lang.Number maxSize;
        private final java.util.List<java.lang.String> metricGroups;
        private final java.lang.Number minSize;
        private final java.lang.String name;
        private final java.lang.String newGameSessionProtectionPolicy;
        private final java.lang.String peerVpcAwsAccountId;
        private final java.lang.String peerVpcId;
        private final java.lang.Object resourceCreationLimitPolicy;
        private final java.lang.Object runtimeConfiguration;
        private final java.lang.String scriptId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.buildId = software.amazon.jsii.Kernel.get(this, "buildId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateConfiguration = software.amazon.jsii.Kernel.get(this, "certificateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.desiredEc2Instances = software.amazon.jsii.Kernel.get(this, "desiredEc2Instances", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ec2InboundPermissions = software.amazon.jsii.Kernel.get(this, "ec2InboundPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ec2InstanceType = software.amazon.jsii.Kernel.get(this, "ec2InstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.fleetType = software.amazon.jsii.Kernel.get(this, "fleetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceRoleArn = software.amazon.jsii.Kernel.get(this, "instanceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.maxSize = software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricGroups = software.amazon.jsii.Kernel.get(this, "metricGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.newGameSessionProtectionPolicy = software.amazon.jsii.Kernel.get(this, "newGameSessionProtectionPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.peerVpcAwsAccountId = software.amazon.jsii.Kernel.get(this, "peerVpcAwsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.peerVpcId = software.amazon.jsii.Kernel.get(this, "peerVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resourceCreationLimitPolicy = software.amazon.jsii.Kernel.get(this, "resourceCreationLimitPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.runtimeConfiguration = software.amazon.jsii.Kernel.get(this, "runtimeConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scriptId = software.amazon.jsii.Kernel.get(this, "scriptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.buildId = builder.buildId;
            this.certificateConfiguration = builder.certificateConfiguration;
            this.description = builder.description;
            this.desiredEc2Instances = builder.desiredEc2Instances;
            this.ec2InboundPermissions = builder.ec2InboundPermissions;
            this.ec2InstanceType = builder.ec2InstanceType;
            this.fleetType = builder.fleetType;
            this.instanceRoleArn = builder.instanceRoleArn;
            this.locations = builder.locations;
            this.maxSize = builder.maxSize;
            this.metricGroups = builder.metricGroups;
            this.minSize = builder.minSize;
            this.name = builder.name;
            this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
            this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
            this.peerVpcId = builder.peerVpcId;
            this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
            this.runtimeConfiguration = builder.runtimeConfiguration;
            this.scriptId = builder.scriptId;
        }

        @Override
        public final java.lang.String getBuildId() {
            return this.buildId;
        }

        @Override
        public final java.lang.Object getCertificateConfiguration() {
            return this.certificateConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getDesiredEc2Instances() {
            return this.desiredEc2Instances;
        }

        @Override
        public final java.lang.Object getEc2InboundPermissions() {
            return this.ec2InboundPermissions;
        }

        @Override
        public final java.lang.String getEc2InstanceType() {
            return this.ec2InstanceType;
        }

        @Override
        public final java.lang.String getFleetType() {
            return this.fleetType;
        }

        @Override
        public final java.lang.String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        @Override
        public final java.lang.Object getLocations() {
            return this.locations;
        }

        @Override
        public final java.lang.Number getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final java.util.List<java.lang.String> getMetricGroups() {
            return this.metricGroups;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        @Override
        public final java.lang.String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        @Override
        public final java.lang.String getPeerVpcId() {
            return this.peerVpcId;
        }

        @Override
        public final java.lang.Object getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy;
        }

        @Override
        public final java.lang.Object getRuntimeConfiguration() {
            return this.runtimeConfiguration;
        }

        @Override
        public final java.lang.String getScriptId() {
            return this.scriptId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBuildId() != null) {
                data.set("buildId", om.valueToTree(this.getBuildId()));
            }
            if (this.getCertificateConfiguration() != null) {
                data.set("certificateConfiguration", om.valueToTree(this.getCertificateConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDesiredEc2Instances() != null) {
                data.set("desiredEc2Instances", om.valueToTree(this.getDesiredEc2Instances()));
            }
            if (this.getEc2InboundPermissions() != null) {
                data.set("ec2InboundPermissions", om.valueToTree(this.getEc2InboundPermissions()));
            }
            if (this.getEc2InstanceType() != null) {
                data.set("ec2InstanceType", om.valueToTree(this.getEc2InstanceType()));
            }
            if (this.getFleetType() != null) {
                data.set("fleetType", om.valueToTree(this.getFleetType()));
            }
            if (this.getInstanceRoleArn() != null) {
                data.set("instanceRoleArn", om.valueToTree(this.getInstanceRoleArn()));
            }
            if (this.getLocations() != null) {
                data.set("locations", om.valueToTree(this.getLocations()));
            }
            if (this.getMaxSize() != null) {
                data.set("maxSize", om.valueToTree(this.getMaxSize()));
            }
            if (this.getMetricGroups() != null) {
                data.set("metricGroups", om.valueToTree(this.getMetricGroups()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getNewGameSessionProtectionPolicy() != null) {
                data.set("newGameSessionProtectionPolicy", om.valueToTree(this.getNewGameSessionProtectionPolicy()));
            }
            if (this.getPeerVpcAwsAccountId() != null) {
                data.set("peerVpcAwsAccountId", om.valueToTree(this.getPeerVpcAwsAccountId()));
            }
            if (this.getPeerVpcId() != null) {
                data.set("peerVpcId", om.valueToTree(this.getPeerVpcId()));
            }
            if (this.getResourceCreationLimitPolicy() != null) {
                data.set("resourceCreationLimitPolicy", om.valueToTree(this.getResourceCreationLimitPolicy()));
            }
            if (this.getRuntimeConfiguration() != null) {
                data.set("runtimeConfiguration", om.valueToTree(this.getRuntimeConfiguration()));
            }
            if (this.getScriptId() != null) {
                data.set("scriptId", om.valueToTree(this.getScriptId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-gamelift.CfnFleetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFleetProps.Jsii$Proxy that = (CfnFleetProps.Jsii$Proxy) o;

            if (this.buildId != null ? !this.buildId.equals(that.buildId) : that.buildId != null) return false;
            if (this.certificateConfiguration != null ? !this.certificateConfiguration.equals(that.certificateConfiguration) : that.certificateConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.desiredEc2Instances != null ? !this.desiredEc2Instances.equals(that.desiredEc2Instances) : that.desiredEc2Instances != null) return false;
            if (this.ec2InboundPermissions != null ? !this.ec2InboundPermissions.equals(that.ec2InboundPermissions) : that.ec2InboundPermissions != null) return false;
            if (this.ec2InstanceType != null ? !this.ec2InstanceType.equals(that.ec2InstanceType) : that.ec2InstanceType != null) return false;
            if (this.fleetType != null ? !this.fleetType.equals(that.fleetType) : that.fleetType != null) return false;
            if (this.instanceRoleArn != null ? !this.instanceRoleArn.equals(that.instanceRoleArn) : that.instanceRoleArn != null) return false;
            if (this.locations != null ? !this.locations.equals(that.locations) : that.locations != null) return false;
            if (this.maxSize != null ? !this.maxSize.equals(that.maxSize) : that.maxSize != null) return false;
            if (this.metricGroups != null ? !this.metricGroups.equals(that.metricGroups) : that.metricGroups != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.newGameSessionProtectionPolicy != null ? !this.newGameSessionProtectionPolicy.equals(that.newGameSessionProtectionPolicy) : that.newGameSessionProtectionPolicy != null) return false;
            if (this.peerVpcAwsAccountId != null ? !this.peerVpcAwsAccountId.equals(that.peerVpcAwsAccountId) : that.peerVpcAwsAccountId != null) return false;
            if (this.peerVpcId != null ? !this.peerVpcId.equals(that.peerVpcId) : that.peerVpcId != null) return false;
            if (this.resourceCreationLimitPolicy != null ? !this.resourceCreationLimitPolicy.equals(that.resourceCreationLimitPolicy) : that.resourceCreationLimitPolicy != null) return false;
            if (this.runtimeConfiguration != null ? !this.runtimeConfiguration.equals(that.runtimeConfiguration) : that.runtimeConfiguration != null) return false;
            return this.scriptId != null ? this.scriptId.equals(that.scriptId) : that.scriptId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.buildId != null ? this.buildId.hashCode() : 0;
            result = 31 * result + (this.certificateConfiguration != null ? this.certificateConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.desiredEc2Instances != null ? this.desiredEc2Instances.hashCode() : 0);
            result = 31 * result + (this.ec2InboundPermissions != null ? this.ec2InboundPermissions.hashCode() : 0);
            result = 31 * result + (this.ec2InstanceType != null ? this.ec2InstanceType.hashCode() : 0);
            result = 31 * result + (this.fleetType != null ? this.fleetType.hashCode() : 0);
            result = 31 * result + (this.instanceRoleArn != null ? this.instanceRoleArn.hashCode() : 0);
            result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
            result = 31 * result + (this.maxSize != null ? this.maxSize.hashCode() : 0);
            result = 31 * result + (this.metricGroups != null ? this.metricGroups.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.newGameSessionProtectionPolicy != null ? this.newGameSessionProtectionPolicy.hashCode() : 0);
            result = 31 * result + (this.peerVpcAwsAccountId != null ? this.peerVpcAwsAccountId.hashCode() : 0);
            result = 31 * result + (this.peerVpcId != null ? this.peerVpcId.hashCode() : 0);
            result = 31 * result + (this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.hashCode() : 0);
            result = 31 * result + (this.runtimeConfiguration != null ? this.runtimeConfiguration.hashCode() : 0);
            result = 31 * result + (this.scriptId != null ? this.scriptId.hashCode() : 0);
            return result;
        }
    }
}
