package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Job Code from a local file.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.alpha.*;
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.iam.*;
 * DockerImage dockerImage;
 * IGrantable grantable;
 * ILocalBundling localBundling;
 * AssetCode assetCode = AssetCode.Builder.create("path")
 *         .assetHash("assetHash")
 *         .assetHashType(AssetHashType.SOURCE)
 *         .bundling(BundlingOptions.builder()
 *                 .image(dockerImage)
 *                 // the properties below are optional
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .command(List.of("command"))
 *                 .entrypoint(List.of("entrypoint"))
 *                 .environment(Map.of(
 *                         "environmentKey", "environment"))
 *                 .local(localBundling)
 *                 .network("network")
 *                 .outputType(BundlingOutput.ARCHIVED)
 *                 .platform("platform")
 *                 .securityOpt("securityOpt")
 *                 .user("user")
 *                 .volumes(List.of(DockerVolume.builder()
 *                         .containerPath("containerPath")
 *                         .hostPath("hostPath")
 *                         // the properties below are optional
 *                         .consistency(DockerVolumeConsistency.CONSISTENT)
 *                         .build()))
 *                 .volumesFrom(List.of("volumesFrom"))
 *                 .workingDirectory("workingDirectory")
 *                 .build())
 *         .deployTime(false)
 *         .exclude(List.of("exclude"))
 *         .followSymlinks(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .readers(List.of(grantable))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.208Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.AssetCode")
public class AssetCode extends software.amazon.awscdk.services.glue.alpha.Code {

    protected AssetCode(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetCode(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param path The path to the Code file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path The path to the Code file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AssetCode(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     * <p>
     * @param scope This parameter is required.
     * @param grantable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantable) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(grantable, "grantable is required") });
    }
}
