package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Identifies if the file contains less or more values for a row than the number of columns specified in the external table definition.
 * <p>
 * This property is only available for an uncompressed text file format.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;column_count_mismatch_handling&#34;_">https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;column_count_mismatch_handling&#34;_</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.210Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.ColumnCountMismatchHandlingAction")
public enum ColumnCountMismatchHandlingAction {
    /**
     * (experimental) Column count mismatch handling is turned off.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DISABLED,
    /**
     * (experimental) Fail the query if the column count mismatch is detected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FAIL,
    /**
     * (experimental) Fill missing values with NULL and ignore the additional values in each row.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SET_TO_NULL,
    /**
     * (experimental) Drop all rows that contain column count mismatch error from the scan.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DROP_ROW,
}
