package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) The compression type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * S3Table.Builder.create(this, "MyTable")
 *         .storageParameters(List.of(StorageParameter.skipHeaderLineCount(1), StorageParameter.compressionType(CompressionType.GZIP), StorageParameter.custom("separatorChar", ",")))
 *         // ...
 *         .database(myDatabase)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;compression_type&#34;_">https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;compression_type&#34;_</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.210Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.CompressionType")
public enum CompressionType {
    /**
     * (experimental) No compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NONE,
    /**
     * (experimental) Burrows-Wheeler compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    BZIP2,
    /**
     * (experimental) Deflate compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    GZIP,
    /**
     * (experimental) Compression algorithm focused on high compression and decompression speeds, rather than the maximum possible compression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SNAPPY,
}
