package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) The type of the glue connection.
 * <p>
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a <code>ConnectionType</code> object, e.g: <code>new ConnectionType('NEW_TYPE')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * Connection.Builder.create(this, "MyConnection")
 *         .type(ConnectionType.NETWORK)
 *         // The security groups granting AWS Glue inbound access to the data source within the VPC
 *         .securityGroups(List.of(securityGroup))
 *         // The VPC subnet which contains the data source
 *         .subnet(subnet)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.212Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.ConnectionType")
public class ConnectionType extends software.amazon.jsii.JsiiObject {

    protected ConnectionType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConnectionType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        JDBC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.ConnectionType.class, "JDBC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.ConnectionType.class));
        KAFKA = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.ConnectionType.class, "KAFKA", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.ConnectionType.class));
        MONGODB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.ConnectionType.class, "MONGODB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.ConnectionType.class));
        NETWORK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.ConnectionType.class, "NETWORK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.ConnectionType.class));
    }

    /**
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ConnectionType(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * (experimental) The connection type name as expected by Connection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Designates a connection to a database through Java Database Connectivity (JDBC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.ConnectionType JDBC;

    /**
     * (experimental) Designates a connection to an Apache Kafka streaming platform.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.ConnectionType KAFKA;

    /**
     * (experimental) Designates a connection to a MongoDB document database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.ConnectionType MONGODB;

    /**
     * (experimental) Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.ConnectionType NETWORK;

    /**
     * (experimental) The name of this ConnectionType, as expected by Connection resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
