package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) A Glue Data Quality ruleset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DataQualityRuleset.Builder.create(this, "MyDataQualityRuleset")
 *         .clientToken("client_token")
 *         .description("description")
 *         .rulesetName("ruleset_name")
 *         .rulesetDqdl("ruleset_dqdl")
 *         .tags(Map.of(
 *                 "key1", "value1",
 *                 "key2", "value2"))
 *         .targetTable(new DataQualityTargetTable("database_name", "table_name"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.215Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.DataQualityRuleset")
public class DataQualityRuleset extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.glue.alpha.IDataQualityRuleset {

    protected DataQualityRuleset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataQualityRuleset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DataQualityRuleset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.DataQualityRulesetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param rulesetArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.IDataQualityRuleset fromRulesetArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String rulesetArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.DataQualityRuleset.class, "fromRulesetArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IDataQualityRuleset.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(rulesetArn, "rulesetArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param rulesetName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.IDataQualityRuleset fromRulesetName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String rulesetName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.DataQualityRuleset.class, "fromRulesetName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IDataQualityRuleset.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(rulesetName, "rulesetName is required") });
    }

    /**
     * (experimental) ARN of this ruleset.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRulesetArn() {
        return software.amazon.jsii.Kernel.get(this, "rulesetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of this ruleset.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRulesetName() {
        return software.amazon.jsii.Kernel.get(this, "rulesetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.alpha.DataQualityRuleset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.alpha.DataQualityRuleset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.alpha.DataQualityRulesetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.alpha.DataQualityRulesetProps.Builder();
        }

        /**
         * (experimental) The dqdl of the ruleset.
         * <p>
         * @return {@code this}
         * @param rulesetDqdl The dqdl of the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rulesetDqdl(final java.lang.String rulesetDqdl) {
            this.props.rulesetDqdl(rulesetDqdl);
            return this;
        }

        /**
         * (experimental) The target table of the ruleset.
         * <p>
         * @return {@code this}
         * @param targetTable The target table of the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetTable(final software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable targetTable) {
            this.props.targetTable(targetTable);
            return this;
        }

        /**
         * (experimental) The client token of the ruleset.
         * <p>
         * @return {@code this}
         * @param clientToken The client token of the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientToken(final java.lang.String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        /**
         * (experimental) The description of the ruleset.
         * <p>
         * @return {@code this}
         * @param description The description of the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) The name of the ruleset.
         * <p>
         * Default: cloudformation generated name
         * <p>
         * @return {@code this}
         * @param rulesetName The name of the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rulesetName(final java.lang.String rulesetName) {
            this.props.rulesetName(rulesetName);
            return this;
        }

        /**
         * (experimental) Key-Value pairs that define tags for the ruleset.
         * <p>
         * Default: empty tags
         * <p>
         * @return {@code this}
         * @param tags Key-Value pairs that define tags for the ruleset. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.alpha.DataQualityRuleset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.alpha.DataQualityRuleset build() {
            return new software.amazon.awscdk.services.glue.alpha.DataQualityRuleset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
