package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Construction properties for <code>DataQualityRuleset</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * DataQualityRuleset.Builder.create(this, "MyDataQualityRuleset")
 *         .clientToken("client_token")
 *         .description("description")
 *         .rulesetName("ruleset_name")
 *         .rulesetDqdl("ruleset_dqdl")
 *         .tags(Map.of(
 *                 "key1", "value1",
 *                 "key2", "value2"))
 *         .targetTable(new DataQualityTargetTable("database_name", "table_name"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.215Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.DataQualityRulesetProps")
@software.amazon.jsii.Jsii.Proxy(DataQualityRulesetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface DataQualityRulesetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The dqdl of the ruleset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getRulesetDqdl();

    /**
     * (experimental) The target table of the ruleset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable getTargetTable();

    /**
     * (experimental) The client token of the ruleset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return null;
    }

    /**
     * (experimental) The description of the ruleset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * (experimental) The name of the ruleset.
     * <p>
     * Default: cloudformation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getRulesetName() {
        return null;
    }

    /**
     * (experimental) Key-Value pairs that define tags for the ruleset.
     * <p>
     * Default: empty tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DataQualityRulesetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DataQualityRulesetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<DataQualityRulesetProps> {
        java.lang.String rulesetDqdl;
        software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable targetTable;
        java.lang.String clientToken;
        java.lang.String description;
        java.lang.String rulesetName;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link DataQualityRulesetProps#getRulesetDqdl}
         * @param rulesetDqdl The dqdl of the ruleset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rulesetDqdl(java.lang.String rulesetDqdl) {
            this.rulesetDqdl = rulesetDqdl;
            return this;
        }

        /**
         * Sets the value of {@link DataQualityRulesetProps#getTargetTable}
         * @param targetTable The target table of the ruleset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetTable(software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        /**
         * Sets the value of {@link DataQualityRulesetProps#getClientToken}
         * @param clientToken The client token of the ruleset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clientToken(java.lang.String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        /**
         * Sets the value of {@link DataQualityRulesetProps#getDescription}
         * @param description The description of the ruleset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link DataQualityRulesetProps#getRulesetName}
         * @param rulesetName The name of the ruleset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder rulesetName(java.lang.String rulesetName) {
            this.rulesetName = rulesetName;
            return this;
        }

        /**
         * Sets the value of {@link DataQualityRulesetProps#getTags}
         * @param tags Key-Value pairs that define tags for the ruleset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DataQualityRulesetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public DataQualityRulesetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DataQualityRulesetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataQualityRulesetProps {
        private final java.lang.String rulesetDqdl;
        private final software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable targetTable;
        private final java.lang.String clientToken;
        private final java.lang.String description;
        private final java.lang.String rulesetName;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.rulesetDqdl = software.amazon.jsii.Kernel.get(this, "rulesetDqdl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetTable = software.amazon.jsii.Kernel.get(this, "targetTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable.class));
            this.clientToken = software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rulesetName = software.amazon.jsii.Kernel.get(this, "rulesetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.rulesetDqdl = java.util.Objects.requireNonNull(builder.rulesetDqdl, "rulesetDqdl is required");
            this.targetTable = java.util.Objects.requireNonNull(builder.targetTable, "targetTable is required");
            this.clientToken = builder.clientToken;
            this.description = builder.description;
            this.rulesetName = builder.rulesetName;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getRulesetDqdl() {
            return this.rulesetDqdl;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.DataQualityTargetTable getTargetTable() {
            return this.targetTable;
        }

        @Override
        public final java.lang.String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRulesetName() {
            return this.rulesetName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("rulesetDqdl", om.valueToTree(this.getRulesetDqdl()));
            data.set("targetTable", om.valueToTree(this.getTargetTable()));
            if (this.getClientToken() != null) {
                data.set("clientToken", om.valueToTree(this.getClientToken()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRulesetName() != null) {
                data.set("rulesetName", om.valueToTree(this.getRulesetName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue-alpha.DataQualityRulesetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DataQualityRulesetProps.Jsii$Proxy that = (DataQualityRulesetProps.Jsii$Proxy) o;

            if (!rulesetDqdl.equals(that.rulesetDqdl)) return false;
            if (!targetTable.equals(that.targetTable)) return false;
            if (this.clientToken != null ? !this.clientToken.equals(that.clientToken) : that.clientToken != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.rulesetName != null ? !this.rulesetName.equals(that.rulesetName) : that.rulesetName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.rulesetDqdl.hashCode();
            result = 31 * result + (this.targetTable.hashCode());
            result = 31 * result + (this.clientToken != null ? this.clientToken.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.rulesetName != null ? this.rulesetName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
