package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) A Glue database.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.glue.alpha.S3Table;
 * import software.amazon.awscdk.services.glue.alpha.Database;
 * import software.amazon.awscdk.services.glue.alpha.DataFormat;
 * import software.amazon.awscdk.services.glue.alpha.Schema;
 * import software.amazon.awscdk.services.lakeformation.CfnDataLakeSettings;
 * import software.amazon.awscdk.services.lakeformation.CfnTag;
 * import software.amazon.awscdk.services.lakeformation.CfnTagAssociation;
 * Stack stack;
 * String accountId;
 * String tagKey = "aws";
 * String[] tagValues = List.of("dev");
 * Database database = new Database(this, "Database");
 * S3Table table = S3Table.Builder.create(this, "Table")
 *         .database(database)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build(), Column.builder()
 *                 .name("col2")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * DefaultStackSynthesizer synthesizer = (DefaultStackSynthesizer)stack.getSynthesizer();
 * CfnDataLakeSettings.Builder.create(this, "DataLakeSettings")
 *         .admins(List.of(DataLakePrincipalProperty.builder()
 *                 .dataLakePrincipalIdentifier(stack.formatArn(ArnComponents.builder()
 *                         .service("iam")
 *                         .resource("role")
 *                         .region("")
 *                         .account(accountId)
 *                         .resourceName("Admin")
 *                         .build()))
 *                 .build(), DataLakePrincipalProperty.builder()
 *                 // The CDK cloudformation execution role.
 *                 .dataLakePrincipalIdentifier(synthesizer.cloudFormationExecutionRoleArn.replace("${AWS::Partition}", "aws"))
 *                 .build()))
 *         .build();
 * CfnTag tag = CfnTag.Builder.create(this, "Tag")
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * LFTagPairProperty lfTagPairProperty = LFTagPairProperty.builder()
 *         .catalogId(accountId)
 *         .tagKey(tagKey)
 *         .tagValues(tagValues)
 *         .build();
 * CfnTagAssociation tagAssociation = CfnTagAssociation.Builder.create(this, "TagAssociation")
 *         .lfTags(List.of(lfTagPairProperty))
 *         .resource(ResourceProperty.builder()
 *                 .tableWithColumns(TableWithColumnsResourceProperty.builder()
 *                         .databaseName(database.getDatabaseName())
 *                         .columnNames(List.of("col1", "col2"))
 *                         .catalogId(accountId)
 *                         .name(table.getTableName())
 *                         .build())
 *                 .build())
 *         .build();
 * tagAssociation.node.addDependency(tag);
 * tagAssociation.node.addDependency(table);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.216Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.Database")
public class Database extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.glue.alpha.IDatabase {

    protected Database(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Database(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Database(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.DatabaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Database(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param databaseArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.IDatabase fromDatabaseArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String databaseArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.Database.class, "fromDatabaseArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IDatabase.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(databaseArn, "databaseArn is required") });
    }

    /**
     * (experimental) ARN of the Glue catalog in which this database is stored.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogArn() {
        return software.amazon.jsii.Kernel.get(this, "catalogArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The catalog id of the database (usually, the AWS account id).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) ARN of this database.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseArn() {
        return software.amazon.jsii.Kernel.get(this, "databaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of this database.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Location URI of this database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getLocationUri() {
        return software.amazon.jsii.Kernel.get(this, "locationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.alpha.Database}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.alpha.Database> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.glue.alpha.DatabaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The name of the database.
         * <p>
         * Default: - generated by CDK.
         * <p>
         * @return {@code this}
         * @param databaseName The name of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props().databaseName(databaseName);
            return this;
        }

        /**
         * (experimental) A description of the database.
         * <p>
         * Default: - no database description
         * <p>
         * @return {@code this}
         * @param description A description of the database. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) The location of the database (for example, an HDFS path).
         * <p>
         * Default: undefined. This field is optional in AWS::Glue::Database DatabaseInput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-database-databaseinput.html</a>
         * @param locationUri The location of the database (for example, an HDFS path). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder locationUri(final java.lang.String locationUri) {
            this.props().locationUri(locationUri);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.alpha.Database}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.alpha.Database build() {
            return new software.amazon.awscdk.services.glue.alpha.Database(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.glue.alpha.DatabaseProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.glue.alpha.DatabaseProps.Builder();
            }
            return this.props;
        }
    }
}
