package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) A Glue table that targets an external data location (e.g. A table in a Redshift Cluster).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Connection myConnection;
 * Database myDatabase;
 * ExternalTable.Builder.create(this, "MyTable")
 *         .connection(myConnection)
 *         .externalDataLocation("default_db_public_example") // A table in Redshift
 *         // ...
 *         .database(myDatabase)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.217Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.ExternalTable")
public class ExternalTable extends software.amazon.awscdk.services.glue.alpha.TableBase {

    protected ExternalTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExternalTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ExternalTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.ExternalTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Grant read permissions to the table.
     * <p>
     * @param grantee the principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Grant read and write permissions to the table.
     * <p>
     * @param grantee the principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantReadWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Grant write permissions to the table.
     * <p>
     * @param grantee the principal. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) The connection associated to this table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.IConnection getConnection() {
        return software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IConnection.class));
    }

    /**
     * (experimental) ARN of this table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
        return software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Name of this table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnTable getTableResource() {
        return software.amazon.jsii.Kernel.get(this, "tableResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.CfnTable.class));
    }

    /**
     * (experimental) This table's partition indexes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex> getPartitionIndexes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex>)(software.amazon.jsii.Kernel.get(this, "partitionIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.PartitionIndex.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.alpha.ExternalTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.alpha.ExternalTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.alpha.ExternalTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.alpha.ExternalTableProps.Builder();
        }

        /**
         * (experimental) Columns of the table.
         * <p>
         * @return {@code this}
         * @param columns Columns of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder columns(final java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Column> columns) {
            this.props.columns(columns);
            return this;
        }

        /**
         * (experimental) Database in which to store the table.
         * <p>
         * @return {@code this}
         * @param database Database in which to store the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder database(final software.amazon.awscdk.services.glue.alpha.IDatabase database) {
            this.props.database(database);
            return this;
        }

        /**
         * (experimental) Storage type of the table's data.
         * <p>
         * @return {@code this}
         * @param dataFormat Storage type of the table's data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataFormat(final software.amazon.awscdk.services.glue.alpha.DataFormat dataFormat) {
            this.props.dataFormat(dataFormat);
            return this;
        }

        /**
         * (experimental) Indicates whether the table's data is compressed or not.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param compressed Indicates whether the table's data is compressed or not. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressed(final java.lang.Boolean compressed) {
            this.props.compressed(compressed);
            return this;
        }

        /**
         * (experimental) Description of the table.
         * <p>
         * Default: generated
         * <p>
         * @return {@code this}
         * @param description Description of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Enables partition filtering.
         * <p>
         * Default: - The parameter is not defined
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/glue-best-practices.html#glue-best-practices-partition-index">https://docs.aws.amazon.com/athena/latest/ug/glue-best-practices.html#glue-best-practices-partition-index</a>
         * @param enablePartitionFiltering Enables partition filtering. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enablePartitionFiltering(final java.lang.Boolean enablePartitionFiltering) {
            this.props.enablePartitionFiltering(enablePartitionFiltering);
            return this;
        }

        /**
         * (experimental) The key/value pairs define properties associated with the table.
         * <p>
         * The key/value pairs that are allowed to be submitted are not limited, however their functionality is not guaranteed.
         * <p>
         * Default: - The parameter is not defined
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-glue-table-tableinput.html#cfn-glue-table-tableinput-parameters</a>
         * @param parameters The key/value pairs define properties associated with the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(final java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * (experimental) Partition indexes on the table.
         * <p>
         * A maximum of 3 indexes
         * are allowed on a table. Keys in the index must be part
         * of the table's partition keys.
         * <p>
         * Default: table has no partition indexes
         * <p>
         * @return {@code this}
         * @param partitionIndexes Partition indexes on the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partitionIndexes(final java.util.List<? extends software.amazon.awscdk.services.glue.alpha.PartitionIndex> partitionIndexes) {
            this.props.partitionIndexes(partitionIndexes);
            return this;
        }

        /**
         * (experimental) Partition columns of the table.
         * <p>
         * Default: table is not partitioned
         * <p>
         * @return {@code this}
         * @param partitionKeys Partition columns of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder partitionKeys(final java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Column> partitionKeys) {
            this.props.partitionKeys(partitionKeys);
            return this;
        }

        /**
         * (experimental) The user-supplied properties for the description of the physical storage of this table.
         * <p>
         * These properties help describe the format of the data that is stored within the crawled data sources.
         * <p>
         * The key/value pairs that are allowed to be submitted are not limited, however their functionality is not guaranteed.
         * <p>
         * Some keys will be auto-populated by glue crawlers, however, you can override them by specifying the key and value in this property.
         * <p>
         * Default: - The parameter is not defined
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * IDatabase glueDatabase;
         * Table table = Table.Builder.create(this, "Table")
         *         .storageParameters(List.of(StorageParameter.skipHeaderLineCount(1), StorageParameter.compressionType(CompressionType.GZIP), StorageParameter.custom("foo", "bar"), StorageParameter.custom("separatorChar", ","), StorageParameter.custom(StorageParameters.WRITE_PARALLEL, "off")))
         *         // ...
         *         .database(glueDatabase)
         *         .columns(List.of(Column.builder()
         *                 .name("col1")
         *                 .type(Schema.STRING)
         *                 .build()))
         *         .dataFormat(DataFormat.CSV)
         *         .build();
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_">https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_</a>
         * @param storageParameters The user-supplied properties for the description of the physical storage of this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storageParameters(final java.util.List<? extends software.amazon.awscdk.services.glue.alpha.StorageParameter> storageParameters) {
            this.props.storageParameters(storageParameters);
            return this;
        }

        /**
         * (experimental) Indicates whether the table data is stored in subdirectories.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param storedAsSubDirectories Indicates whether the table data is stored in subdirectories. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storedAsSubDirectories(final java.lang.Boolean storedAsSubDirectories) {
            this.props.storedAsSubDirectories(storedAsSubDirectories);
            return this;
        }

        /**
         * (experimental) Name of the table.
         * <p>
         * Default: - generated by CDK.
         * <p>
         * @return {@code this}
         * @param tableName Name of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * (experimental) The connection the table will use when performing reads and writes.
         * <p>
         * Default: - No connection
         * <p>
         * @return {@code this}
         * @param connection The connection the table will use when performing reads and writes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connection(final software.amazon.awscdk.services.glue.alpha.IConnection connection) {
            this.props.connection(connection);
            return this;
        }

        /**
         * (experimental) The data source location of the glue table, (e.g. <code>default_db_public_example</code> for Redshift).
         * <p>
         * If this property is set, it will override both <code>bucket</code> and <code>s3Prefix</code>.
         * <p>
         * Default: - No outsourced data source location
         * <p>
         * @return {@code this}
         * @param externalDataLocation The data source location of the glue table, (e.g. <code>default_db_public_example</code> for Redshift). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder externalDataLocation(final java.lang.String externalDataLocation) {
            this.props.externalDataLocation(externalDataLocation);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.alpha.ExternalTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.alpha.ExternalTable build() {
            return new software.amazon.awscdk.services.glue.alpha.ExternalTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
