package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) A Glue Job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Job.Builder.create(this, "EnableSparkUI")
 *         .jobName("EtlJobWithSparkUIPrefix")
 *         .sparkUI(SparkUIProps.builder()
 *                 .enabled(true)
 *                 .build())
 *         .executable(JobExecutable.pythonEtl(PythonSparkJobExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V3_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromAsset(join(__dirname, "job-script/hello_world.py")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.239Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.Job")
public class Job extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.glue.alpha.IJob {

    protected Job(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Job(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Job(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a Glue Job.
     * <p>
     * @param scope The scope creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's id. This parameter is required.
     * @param attrs Import attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.IJob fromJobAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.Job.class, "fromJobAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IJob.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) Create a CloudWatch metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
     * @param metricName name of the metric typically prefixed with <code>glue.driver.</code>, <code>glue.&lt;executorId&gt;.</code> or <code>glue.ALL.</code>. This parameter is required.
     * @param type the metric type. This parameter is required.
     * @param props metric options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.MetricType type, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(type, "type is required"), props });
    }

    /**
     * (experimental) Create a CloudWatch metric.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html">https://docs.aws.amazon.com/glue/latest/dg/monitoring-awsglue-with-cloudwatch-metrics.html</a>
     * @param metricName name of the metric typically prefixed with <code>glue.driver.</code>, <code>glue.&lt;executorId&gt;.</code> or <code>glue.ALL.</code>. This parameter is required.
     * @param type the metric type. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.MetricType type) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), java.util.Objects.requireNonNull(type, "type is required") });
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job failure.
     * <p>
     * This metric is based on the Rule returned by no-args onFailure() call.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job failure.
     * <p>
     * This metric is based on the Rule returned by no-args onFailure() call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricFailure() {
        return software.amazon.jsii.Kernel.call(this, "metricFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job success.
     * <p>
     * This metric is based on the Rule returned by no-args onSuccess() call.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job success.
     * <p>
     * This metric is based on the Rule returned by no-args onSuccess() call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricSuccess() {
        return software.amazon.jsii.Kernel.call(this, "metricSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job timeout.
     * <p>
     * This metric is based on the Rule returned by no-args onTimeout() call.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Return a CloudWatch Metric indicating job timeout.
     * <p>
     * This metric is based on the Rule returned by no-args onTimeout() call.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricTimeout() {
        return software.amazon.jsii.Kernel.call(this, "metricTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Create a CloudWatch Event Rule for this Glue Job when it's in a given state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id construct id. This parameter is required.
     * @param options event options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Create a CloudWatch Event Rule for this Glue Job when it's in a given state.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#glue-event-types</a>
     * @param id construct id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Return a CloudWatch Event Rule matching FAILED state.
     * <p>
     * @param id construct id. This parameter is required.
     * @param options optional event options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Return a CloudWatch Event Rule matching FAILED state.
     * <p>
     * @param id construct id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onFailure(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onFailure", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Create a CloudWatch Event Rule for the transition into the input jobState.
     * <p>
     * @param id construct id. This parameter is required.
     * @param jobState the job state. This parameter is required.
     * @param options optional event options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobState jobState, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobState, "jobState is required"), options });
    }

    /**
     * (experimental) Create a CloudWatch Event Rule for the transition into the input jobState.
     * <p>
     * @param id construct id. This parameter is required.
     * @param jobState the job state. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobState jobState) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobState, "jobState is required") });
    }

    /**
     * (experimental) Create a CloudWatch Event Rule matching JobState.SUCCEEDED.
     * <p>
     * @param id construct id. This parameter is required.
     * @param options optional event options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Create a CloudWatch Event Rule matching JobState.SUCCEEDED.
     * <p>
     * @param id construct id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onSuccess(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onSuccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Return a CloudWatch Event Rule matching TIMEOUT state.
     * <p>
     * @param id construct id. This parameter is required.
     * @param options optional event options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Return a CloudWatch Event Rule matching TIMEOUT state.
     * <p>
     * @param id construct id. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onTimeout(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) The principal this Glue Job is running as.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) The ARN of the job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobArn() {
        return software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobName() {
        return software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM role Glue assumes to run this job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) The Spark UI logs location if Spark UI monitoring and debugging is enabled.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.SparkUILoggingLocation getSparkUILoggingLocation() {
        return software.amazon.jsii.Kernel.get(this, "sparkUILoggingLocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.SparkUILoggingLocation.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.alpha.Job}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.alpha.Job> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.alpha.JobProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.alpha.JobProps.Builder();
        }

        /**
         * (experimental) The job's executable properties.
         * <p>
         * @return {@code this}
         * @param executable The job's executable properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executable(final software.amazon.awscdk.services.glue.alpha.JobExecutable executable) {
            this.props.executable(executable);
            return this;
        }

        /**
         * (experimental) The <code>Connection</code>s used for this job.
         * <p>
         * Connections are used to connect to other AWS Service or resources within a VPC.
         * <p>
         * Default: [] - no connections are added to the job
         * <p>
         * @return {@code this}
         * @param connections The <code>Connection</code>s used for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connections(final java.util.List<? extends software.amazon.awscdk.services.glue.alpha.IConnection> connections) {
            this.props.connections(connections);
            return this;
        }

        /**
         * (experimental) Enables continuous logging with the specified props.
         * <p>
         * Default: - continuous logging is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
         * @param continuousLogging Enables continuous logging with the specified props. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder continuousLogging(final software.amazon.awscdk.services.glue.alpha.ContinuousLoggingProps continuousLogging) {
            this.props.continuousLogging(continuousLogging);
            return this;
        }

        /**
         * (experimental) The default arguments for this job, specified as name-value pairs.
         * <p>
         * Default: - no arguments
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html for a list of reserved parameters">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html for a list of reserved parameters</a>
         * @param defaultArguments The default arguments for this job, specified as name-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultArguments(final java.util.Map<java.lang.String, java.lang.String> defaultArguments) {
            this.props.defaultArguments(defaultArguments);
            return this;
        }

        /**
         * (experimental) The description of the job.
         * <p>
         * Default: - no value
         * <p>
         * @return {@code this}
         * @param description The description of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Enables the collection of metrics for job profiling.
         * <p>
         * Default: - no profiling metrics emitted.
         * <p>
         * @return {@code this}
         * @see <a href=" `--enable-metrics` at https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--enable-metrics` at https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
         * @param enableProfilingMetrics Enables the collection of metrics for job profiling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableProfilingMetrics(final java.lang.Boolean enableProfilingMetrics) {
            this.props.enableProfilingMetrics(enableProfilingMetrics);
            return this;
        }

        /**
         * (experimental) The ExecutionClass whether the job is run with a standard or flexible execution class.
         * <p>
         * Default: - STANDARD
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/add-job.html">https://docs.aws.amazon.com/glue/latest/dg/add-job.html</a>
         * @param executionClass The ExecutionClass whether the job is run with a standard or flexible execution class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executionClass(final software.amazon.awscdk.services.glue.alpha.ExecutionClass executionClass) {
            this.props.executionClass(executionClass);
            return this;
        }

        /**
         * (experimental) The name of the job.
         * <p>
         * Default: - a name is automatically generated
         * <p>
         * @return {@code this}
         * @param jobName The name of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobName(final java.lang.String jobName) {
            this.props.jobName(jobName);
            return this;
        }

        /**
         * (experimental) The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs.
         * <p>
         * Cannot be used for Glue version 2.0 and later - workerType and workerCount should be used instead.
         * <p>
         * Default: - 10 when job type is Apache Spark ETL or streaming, 0.0625 when job type is Python shell
         * <p>
         * @return {@code this}
         * @param maxCapacity The number of AWS Glue data processing units (DPUs) that can be allocated when this job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * (experimental) The maximum number of concurrent runs allowed for the job.
         * <p>
         * An error is returned when this threshold is reached. The maximum value you can specify is controlled by a service limit.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param maxConcurrentRuns The maximum number of concurrent runs allowed for the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxConcurrentRuns(final java.lang.Number maxConcurrentRuns) {
            this.props.maxConcurrentRuns(maxConcurrentRuns);
            return this;
        }

        /**
         * (experimental) The maximum number of times to retry this job after a job run fails.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param maxRetries The maximum number of times to retry this job after a job run fails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxRetries(final java.lang.Number maxRetries) {
            this.props.maxRetries(maxRetries);
            return this;
        }

        /**
         * (experimental) The number of minutes to wait after a job run starts, before sending a job run delay notification.
         * <p>
         * Default: - no delay notifications
         * <p>
         * @return {@code this}
         * @param notifyDelayAfter The number of minutes to wait after a job run starts, before sending a job run delay notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notifyDelayAfter(final software.amazon.awscdk.Duration notifyDelayAfter) {
            this.props.notifyDelayAfter(notifyDelayAfter);
            return this;
        }

        /**
         * (experimental) The IAM role assumed by Glue to run this job.
         * <p>
         * If providing a custom role, it needs to trust the Glue service principal (glue.amazonaws.com) and be granted sufficient permissions.
         * <p>
         * Default: - a role is automatically generated
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/getting-started-access.html">https://docs.aws.amazon.com/glue/latest/dg/getting-started-access.html</a>
         * @param role The IAM role assumed by Glue to run this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The <code>SecurityConfiguration</code> to use for this job.
         * <p>
         * Default: - no security configuration.
         * <p>
         * @return {@code this}
         * @param securityConfiguration The <code>SecurityConfiguration</code> to use for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfiguration(final software.amazon.awscdk.services.glue.alpha.ISecurityConfiguration securityConfiguration) {
            this.props.securityConfiguration(securityConfiguration);
            return this;
        }

        /**
         * (experimental) Enables the Spark UI debugging and monitoring with the specified props.
         * <p>
         * Default: - Spark UI debugging and monitoring is disabled.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
         * @param sparkUi Enables the Spark UI debugging and monitoring with the specified props. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sparkUi(final software.amazon.awscdk.services.glue.alpha.SparkUIProps sparkUi) {
            this.props.sparkUi(sparkUi);
            return this;
        }

        /**
         * (experimental) The tags to add to the resources on which the job runs.
         * <p>
         * Default: {} - no tags
         * <p>
         * @return {@code this}
         * @param tags The tags to add to the resources on which the job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * (experimental) The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status.
         * <p>
         * Default: cdk.Duration.hours(48)
         * <p>
         * @return {@code this}
         * @param timeout The maximum time that a job run can consume resources before it is terminated and enters TIMEOUT status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * (experimental) The number of workers of a defined <code>WorkerType</code> that are allocated when a job runs.
         * <p>
         * Default: - differs based on specific Glue version/worker type
         * <p>
         * @return {@code this}
         * @param workerCount The number of workers of a defined <code>WorkerType</code> that are allocated when a job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workerCount(final java.lang.Number workerCount) {
            this.props.workerCount(workerCount);
            return this;
        }

        /**
         * (experimental) The type of predefined worker that is allocated when a job runs.
         * <p>
         * Default: - differs based on specific Glue version
         * <p>
         * @return {@code this}
         * @param workerType The type of predefined worker that is allocated when a job runs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder workerType(final software.amazon.awscdk.services.glue.alpha.WorkerType workerType) {
            this.props.workerType(workerType);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.glue.alpha.Job}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.alpha.Job build() {
            return new software.amazon.awscdk.services.glue.alpha.Job(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
