package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Encryption mode for Job Bookmarks.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityConfiguration.Builder.create(this, "MySecurityConfiguration")
 *         .cloudWatchEncryption(CloudWatchEncryption.builder()
 *                 .mode(CloudWatchEncryptionMode.KMS)
 *                 .build())
 *         .jobBookmarksEncryption(JobBookmarksEncryption.builder()
 *                 .mode(JobBookmarksEncryptionMode.CLIENT_SIDE_KMS)
 *                 .build())
 *         .s3Encryption(S3Encryption.builder()
 *                 .mode(S3EncryptionMode.KMS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode">https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.JobBookmarksEncryptionMode")
public enum JobBookmarksEncryptionMode {
    /**
     * (experimental) Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    CLIENT_SIDE_KMS,
}
