package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) The executable properties related to the Glue job's GlueVersion, JobType and code.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Job.Builder.create(this, "EnableSparkUI")
 *         .jobName("EtlJobWithSparkUIPrefix")
 *         .sparkUI(SparkUIProps.builder()
 *                 .enabled(true)
 *                 .build())
 *         .executable(JobExecutable.pythonEtl(PythonSparkJobExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V3_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromAsset(join(__dirname, "job-script/hello_world.py")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.242Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.JobExecutable")
public class JobExecutable extends software.amazon.jsii.JsiiObject {

    protected JobExecutable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobExecutable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Create a custom JobExecutable.
     * <p>
     * @param config custom job executable configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutableConfig config) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(config, "config is required") });
    }

    /**
     * (experimental) Create Python executable props for Apache Spark ETL job.
     * <p>
     * @param props Python Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable pythonEtl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.PythonSparkJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "pythonEtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Python executable props for Ray jobs.
     * <p>
     * @param props Ray Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable pythonRay(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.PythonRayExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "pythonRay", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Python executable props for python shell jobs.
     * <p>
     * @param props Python Shell Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable pythonShell(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.PythonShellExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "pythonShell", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Python executable props for Apache Spark Streaming job.
     * <p>
     * @param props Python Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable pythonStreaming(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.PythonSparkJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "pythonStreaming", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Scala executable props for Apache Spark ETL job.
     * <p>
     * @param props Scala Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable scalaEtl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.ScalaJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "scalaEtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Create Scala executable props for Apache Spark Streaming job.
     * <p>
     * @param props Scala Apache Spark Job props. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutable scalaStreaming(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.ScalaJobExecutableProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.JobExecutable.class, "scalaStreaming", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutable.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Called during Job initialization to get JobExecutableConfig.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobExecutableConfig bind() {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobExecutableConfig.class));
    }
}
