package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Result of binding a <code>JobExecutable</code> into a <code>Job</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.alpha.*;
 * Code code;
 * GlueVersion glueVersion;
 * JobType jobType;
 * Runtime runtime;
 * JobExecutableConfig jobExecutableConfig = JobExecutableConfig.builder()
 *         .glueVersion(glueVersion)
 *         .language(JobLanguage.SCALA)
 *         .script(code)
 *         .type(jobType)
 *         // the properties below are optional
 *         .className("className")
 *         .extraFiles(List.of(code))
 *         .extraJars(List.of(code))
 *         .extraJarsFirst(false)
 *         .extraPythonFiles(List.of(code))
 *         .pythonVersion(PythonVersion.TWO)
 *         .runtime(runtime)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.242Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.JobExecutableConfig")
@software.amazon.jsii.Jsii.Proxy(JobExecutableConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface JobExecutableConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Glue version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html">https://docs.aws.amazon.com/glue/latest/dg/release-notes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.GlueVersion getGlueVersion();

    /**
     * (experimental) The language of the job (Scala or Python).
     * <p>
     * @see <a href=" `--job-language` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--job-language` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobLanguage getLanguage();

    /**
     * (experimental) The script that is executed by a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.Code getScript();

    /**
     * (experimental) Specify the type of the job whether it's an Apache Spark ETL or streaming one or if it's a Python shell job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.JobType getType();

    /**
     * (experimental) The Scala class that serves as the entry point for the job.
     * <p>
     * This applies only if your the job langauage is Scala.
     * <p>
     * Default: - no scala className specified
     * <p>
     * @see <a href=" `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getClassName() {
        return null;
    }

    /**
     * (experimental) Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
     * <p>
     * Default: - no extra files specified.
     * <p>
     * @see <a href=" `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraFiles() {
        return null;
    }

    /**
     * (experimental) Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script.
     * <p>
     * Default: - no extra jars specified.
     * <p>
     * @see <a href=" `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraJars() {
        return null;
    }

    /**
     * (experimental) Setting this value to true prioritizes the customer's extra JAR files in the classpath.
     * <p>
     * Default: - extra jars are not prioritized.
     * <p>
     * @see <a href=" `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExtraJarsFirst() {
        return null;
    }

    /**
     * (experimental) Additional Python files that AWS Glue adds to the Python path before executing your script.
     * <p>
     * Default: - no extra python files specified.
     * <p>
     * @see <a href=" `--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraPythonFiles() {
        return null;
    }

    /**
     * (experimental) The Python version to use.
     * <p>
     * Default: - no python version specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.PythonVersion getPythonVersion() {
        return null;
    }

    /**
     * (experimental) The Runtime to use.
     * <p>
     * Default: - no runtime specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.Runtime getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link JobExecutableConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link JobExecutableConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<JobExecutableConfig> {
        software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion;
        software.amazon.awscdk.services.glue.alpha.JobLanguage language;
        software.amazon.awscdk.services.glue.alpha.Code script;
        software.amazon.awscdk.services.glue.alpha.JobType type;
        java.lang.String className;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraFiles;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraJars;
        java.lang.Boolean extraJarsFirst;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraPythonFiles;
        software.amazon.awscdk.services.glue.alpha.PythonVersion pythonVersion;
        software.amazon.awscdk.services.glue.alpha.Runtime runtime;

        /**
         * Sets the value of {@link JobExecutableConfig#getGlueVersion}
         * @param glueVersion Glue version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder glueVersion(software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getLanguage}
         * @param language The language of the job (Scala or Python). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder language(software.amazon.awscdk.services.glue.alpha.JobLanguage language) {
            this.language = language;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getScript}
         * @param script The script that is executed by a job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder script(software.amazon.awscdk.services.glue.alpha.Code script) {
            this.script = script;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getType}
         * @param type Specify the type of the job whether it's an Apache Spark ETL or streaming one or if it's a Python shell job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.services.glue.alpha.JobType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getClassName}
         * @param className The Scala class that serves as the entry point for the job.
         *                  This applies only if your the job langauage is Scala.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder className(java.lang.String className) {
            this.className = className;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getExtraFiles}
         * @param extraFiles Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraFiles(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Code> extraFiles) {
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)extraFiles;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getExtraJars}
         * @param extraJars Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraJars(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Code> extraJars) {
            this.extraJars = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)extraJars;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getExtraJarsFirst}
         * @param extraJarsFirst Setting this value to true prioritizes the customer's extra JAR files in the classpath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraJarsFirst(java.lang.Boolean extraJarsFirst) {
            this.extraJarsFirst = extraJarsFirst;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getExtraPythonFiles}
         * @param extraPythonFiles Additional Python files that AWS Glue adds to the Python path before executing your script.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraPythonFiles(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Code> extraPythonFiles) {
            this.extraPythonFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)extraPythonFiles;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getPythonVersion}
         * @param pythonVersion The Python version to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pythonVersion(software.amazon.awscdk.services.glue.alpha.PythonVersion pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        /**
         * Sets the value of {@link JobExecutableConfig#getRuntime}
         * @param runtime The Runtime to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.glue.alpha.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link JobExecutableConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public JobExecutableConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link JobExecutableConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JobExecutableConfig {
        private final software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion;
        private final software.amazon.awscdk.services.glue.alpha.JobLanguage language;
        private final software.amazon.awscdk.services.glue.alpha.Code script;
        private final software.amazon.awscdk.services.glue.alpha.JobType type;
        private final java.lang.String className;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraFiles;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraJars;
        private final java.lang.Boolean extraJarsFirst;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraPythonFiles;
        private final software.amazon.awscdk.services.glue.alpha.PythonVersion pythonVersion;
        private final software.amazon.awscdk.services.glue.alpha.Runtime runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.GlueVersion.class));
            this.language = software.amazon.jsii.Kernel.get(this, "language", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobLanguage.class));
            this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobType.class));
            this.className = software.amazon.jsii.Kernel.get(this, "className", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.extraFiles = software.amazon.jsii.Kernel.get(this, "extraFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class)));
            this.extraJars = software.amazon.jsii.Kernel.get(this, "extraJars", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class)));
            this.extraJarsFirst = software.amazon.jsii.Kernel.get(this, "extraJarsFirst", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.extraPythonFiles = software.amazon.jsii.Kernel.get(this, "extraPythonFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class)));
            this.pythonVersion = software.amazon.jsii.Kernel.get(this, "pythonVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.PythonVersion.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Runtime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.glueVersion = java.util.Objects.requireNonNull(builder.glueVersion, "glueVersion is required");
            this.language = java.util.Objects.requireNonNull(builder.language, "language is required");
            this.script = java.util.Objects.requireNonNull(builder.script, "script is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.className = builder.className;
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)builder.extraFiles;
            this.extraJars = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)builder.extraJars;
            this.extraJarsFirst = builder.extraJarsFirst;
            this.extraPythonFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)builder.extraPythonFiles;
            this.pythonVersion = builder.pythonVersion;
            this.runtime = builder.runtime;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.GlueVersion getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.JobLanguage getLanguage() {
            return this.language;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.Code getScript() {
            return this.script;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.JobType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getClassName() {
            return this.className;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraFiles() {
            return this.extraFiles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraJars() {
            return this.extraJars;
        }

        @Override
        public final java.lang.Boolean getExtraJarsFirst() {
            return this.extraJarsFirst;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraPythonFiles() {
            return this.extraPythonFiles;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.PythonVersion getPythonVersion() {
            return this.pythonVersion;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            data.set("language", om.valueToTree(this.getLanguage()));
            data.set("script", om.valueToTree(this.getScript()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getClassName() != null) {
                data.set("className", om.valueToTree(this.getClassName()));
            }
            if (this.getExtraFiles() != null) {
                data.set("extraFiles", om.valueToTree(this.getExtraFiles()));
            }
            if (this.getExtraJars() != null) {
                data.set("extraJars", om.valueToTree(this.getExtraJars()));
            }
            if (this.getExtraJarsFirst() != null) {
                data.set("extraJarsFirst", om.valueToTree(this.getExtraJarsFirst()));
            }
            if (this.getExtraPythonFiles() != null) {
                data.set("extraPythonFiles", om.valueToTree(this.getExtraPythonFiles()));
            }
            if (this.getPythonVersion() != null) {
                data.set("pythonVersion", om.valueToTree(this.getPythonVersion()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue-alpha.JobExecutableConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            JobExecutableConfig.Jsii$Proxy that = (JobExecutableConfig.Jsii$Proxy) o;

            if (!glueVersion.equals(that.glueVersion)) return false;
            if (!language.equals(that.language)) return false;
            if (!script.equals(that.script)) return false;
            if (!type.equals(that.type)) return false;
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) return false;
            if (this.extraFiles != null ? !this.extraFiles.equals(that.extraFiles) : that.extraFiles != null) return false;
            if (this.extraJars != null ? !this.extraJars.equals(that.extraJars) : that.extraJars != null) return false;
            if (this.extraJarsFirst != null ? !this.extraJarsFirst.equals(that.extraJarsFirst) : that.extraJarsFirst != null) return false;
            if (this.extraPythonFiles != null ? !this.extraPythonFiles.equals(that.extraPythonFiles) : that.extraPythonFiles != null) return false;
            if (this.pythonVersion != null ? !this.pythonVersion.equals(that.pythonVersion) : that.pythonVersion != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.glueVersion.hashCode();
            result = 31 * result + (this.language.hashCode());
            result = 31 * result + (this.script.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
            result = 31 * result + (this.extraFiles != null ? this.extraFiles.hashCode() : 0);
            result = 31 * result + (this.extraJars != null ? this.extraJars.hashCode() : 0);
            result = 31 * result + (this.extraJarsFirst != null ? this.extraJarsFirst.hashCode() : 0);
            result = 31 * result + (this.extraPythonFiles != null ? this.extraPythonFiles.hashCode() : 0);
            result = 31 * result + (this.pythonVersion != null ? this.pythonVersion.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
