package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) AWS Glue runtime determines the runtime engine of the job.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Job.Builder.create(this, "RayJob")
 *         .executable(JobExecutable.pythonRay(PythonRayExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V4_0)
 *                 .pythonVersion(PythonVersion.THREE_NINE)
 *                 .runtime(Runtime.RAY_TWO_FOUR)
 *                 .script(Code.fromAsset(join(__dirname, "job-script/hello_world.py")))
 *                 .build()))
 *         .workerType(WorkerType.Z_2X)
 *         .workerCount(2)
 *         .description("an example Ray job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.247Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.Runtime")
public class Runtime extends software.amazon.jsii.JsiiObject {

    protected Runtime(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Runtime(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RAY_TWO_FOUR = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.Runtime.class, "RAY_TWO_FOUR", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Runtime.class));
    }

    /**
     * (experimental) Custom runtime.
     * <p>
     * @param runtime custom runtime. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.Runtime of(final @org.jetbrains.annotations.NotNull java.lang.String runtime) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.Runtime.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Runtime.class), new Object[] { java.util.Objects.requireNonNull(runtime, "runtime is required") });
    }

    /**
     * (experimental) Runtime for a Glue for Ray 2.4.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.Runtime RAY_TWO_FOUR;

    /**
     * (experimental) The name of this Runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
