package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Props for creating a Scala Spark (ETL or Streaming) job executable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "ScalaSparkEtlJob")
 *         .executable(JobExecutable.scalaEtl(ScalaJobExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V4_0)
 *                 .script(Code.fromBucket(bucket, "src/com/example/HelloWorld.scala"))
 *                 .className("com.example.HelloWorld")
 *                 .extraJars(List.of(Code.fromBucket(bucket, "jars/HelloWorld.jar")))
 *                 .build()))
 *         .workerType(WorkerType.G_8X)
 *         .description("an example Scala ETL job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.251Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.ScalaJobExecutableProps")
@software.amazon.jsii.Jsii.Proxy(ScalaJobExecutableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ScalaJobExecutableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The fully qualified Scala class name that serves as the entry point for the job.
     * <p>
     * @see <a href=" `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--class` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getClassName();

    /**
     * (experimental) Glue version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html">https://docs.aws.amazon.com/glue/latest/dg/release-notes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.GlueVersion getGlueVersion();

    /**
     * (experimental) The script that executes a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.Code getScript();

    /**
     * (experimental) Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
     * <p>
     * Only individual files are supported, directories are not supported.
     * <p>
     * Default: [] - no extra files are copied to the working directory
     * <p>
     * @see <a href=" `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraFiles() {
        return null;
    }

    /**
     * (experimental) Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported.
     * <p>
     * Default: [] - no extra jars are added to the classpath
     * <p>
     * @see <a href=" `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--extra-jars` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraJars() {
        return null;
    }

    /**
     * (experimental) Setting this value to true prioritizes the customer's extra JAR files in the classpath.
     * <p>
     * Default: false - priority is not given to user-provided jars
     * <p>
     * @see <a href=" `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html"> `--user-jars-first` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExtraJarsFirst() {
        return null;
    }

    /**
     * (experimental) Runtime.
     * <p>
     * It is required for Ray jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.Runtime getRuntime() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScalaJobExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScalaJobExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ScalaJobExecutableProps> {
        java.lang.String className;
        software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion;
        software.amazon.awscdk.services.glue.alpha.Code script;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraFiles;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraJars;
        java.lang.Boolean extraJarsFirst;
        software.amazon.awscdk.services.glue.alpha.Runtime runtime;

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getClassName}
         * @param className The fully qualified Scala class name that serves as the entry point for the job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder className(java.lang.String className) {
            this.className = className;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getGlueVersion}
         * @param glueVersion Glue version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder glueVersion(software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getScript}
         * @param script The script that executes a job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder script(software.amazon.awscdk.services.glue.alpha.Code script) {
            this.script = script;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getExtraFiles}
         * @param extraFiles Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
         *                   Only individual files are supported, directories are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraFiles(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Code> extraFiles) {
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)extraFiles;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getExtraJars}
         * @param extraJars Additional Java .jar files that AWS Glue adds to the Java classpath before executing your script. Only individual files are supported, directories are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraJars(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Code> extraJars) {
            this.extraJars = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)extraJars;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getExtraJarsFirst}
         * @param extraJarsFirst Setting this value to true prioritizes the customer's extra JAR files in the classpath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder extraJarsFirst(java.lang.Boolean extraJarsFirst) {
            this.extraJarsFirst = extraJarsFirst;
            return this;
        }

        /**
         * Sets the value of {@link ScalaJobExecutableProps#getRuntime}
         * @param runtime Runtime.
         *                It is required for Ray jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(software.amazon.awscdk.services.glue.alpha.Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScalaJobExecutableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ScalaJobExecutableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScalaJobExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScalaJobExecutableProps {
        private final java.lang.String className;
        private final software.amazon.awscdk.services.glue.alpha.GlueVersion glueVersion;
        private final software.amazon.awscdk.services.glue.alpha.Code script;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraFiles;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> extraJars;
        private final java.lang.Boolean extraJarsFirst;
        private final software.amazon.awscdk.services.glue.alpha.Runtime runtime;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.className = software.amazon.jsii.Kernel.get(this, "className", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.GlueVersion.class));
            this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class));
            this.extraFiles = software.amazon.jsii.Kernel.get(this, "extraFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class)));
            this.extraJars = software.amazon.jsii.Kernel.get(this, "extraJars", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Code.class)));
            this.extraJarsFirst = software.amazon.jsii.Kernel.get(this, "extraJarsFirst", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.runtime = software.amazon.jsii.Kernel.get(this, "runtime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Runtime.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.className = java.util.Objects.requireNonNull(builder.className, "className is required");
            this.glueVersion = java.util.Objects.requireNonNull(builder.glueVersion, "glueVersion is required");
            this.script = java.util.Objects.requireNonNull(builder.script, "script is required");
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)builder.extraFiles;
            this.extraJars = (java.util.List<software.amazon.awscdk.services.glue.alpha.Code>)builder.extraJars;
            this.extraJarsFirst = builder.extraJarsFirst;
            this.runtime = builder.runtime;
        }

        @Override
        public final java.lang.String getClassName() {
            return this.className;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.GlueVersion getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.Code getScript() {
            return this.script;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraFiles() {
            return this.extraFiles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Code> getExtraJars() {
            return this.extraJars;
        }

        @Override
        public final java.lang.Boolean getExtraJarsFirst() {
            return this.extraJarsFirst;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.Runtime getRuntime() {
            return this.runtime;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("className", om.valueToTree(this.getClassName()));
            data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            data.set("script", om.valueToTree(this.getScript()));
            if (this.getExtraFiles() != null) {
                data.set("extraFiles", om.valueToTree(this.getExtraFiles()));
            }
            if (this.getExtraJars() != null) {
                data.set("extraJars", om.valueToTree(this.getExtraJars()));
            }
            if (this.getExtraJarsFirst() != null) {
                data.set("extraJarsFirst", om.valueToTree(this.getExtraJarsFirst()));
            }
            if (this.getRuntime() != null) {
                data.set("runtime", om.valueToTree(this.getRuntime()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue-alpha.ScalaJobExecutableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScalaJobExecutableProps.Jsii$Proxy that = (ScalaJobExecutableProps.Jsii$Proxy) o;

            if (!className.equals(that.className)) return false;
            if (!glueVersion.equals(that.glueVersion)) return false;
            if (!script.equals(that.script)) return false;
            if (this.extraFiles != null ? !this.extraFiles.equals(that.extraFiles) : that.extraFiles != null) return false;
            if (this.extraJars != null ? !this.extraJars.equals(that.extraJars) : that.extraJars != null) return false;
            if (this.extraJarsFirst != null ? !this.extraJarsFirst.equals(that.extraJarsFirst) : that.extraJarsFirst != null) return false;
            return this.runtime != null ? this.runtime.equals(that.runtime) : that.runtime == null;
        }

        @Override
        public final int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + (this.glueVersion.hashCode());
            result = 31 * result + (this.script.hashCode());
            result = 31 * result + (this.extraFiles != null ? this.extraFiles.hashCode() : 0);
            result = 31 * result + (this.extraJars != null ? this.extraJars.hashCode() : 0);
            result = 31 * result + (this.extraJarsFirst != null ? this.extraJarsFirst.hashCode() : 0);
            result = 31 * result + (this.runtime != null ? this.runtime.hashCode() : 0);
            return result;
        }
    }
}
