package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Constructions properties of <code>SecurityConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityConfiguration.Builder.create(this, "MySecurityConfiguration")
 *         .cloudWatchEncryption(CloudWatchEncryption.builder()
 *                 .mode(CloudWatchEncryptionMode.KMS)
 *                 .build())
 *         .jobBookmarksEncryption(JobBookmarksEncryption.builder()
 *                 .mode(JobBookmarksEncryptionMode.CLIENT_SIDE_KMS)
 *                 .build())
 *         .s3Encryption(S3Encryption.builder()
 *                 .mode(S3EncryptionMode.KMS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.253Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.SecurityConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(SecurityConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SecurityConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The encryption configuration for Amazon CloudWatch Logs.
     * <p>
     * Default: no cloudwatch logs encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption getCloudWatchEncryption() {
        return null;
    }

    /**
     * (experimental) The encryption configuration for Glue Job Bookmarks.
     * <p>
     * Default: no job bookmarks encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption getJobBookmarksEncryption() {
        return null;
    }

    /**
     * (experimental) The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
     * <p>
     * Default: no s3 encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.alpha.S3Encryption getS3Encryption() {
        return null;
    }

    /**
     * (experimental) The name of the security configuration.
     * <p>
     * Default: - generated by CDK.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecurityConfigurationName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityConfigurationProps> {
        software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption cloudWatchEncryption;
        software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption jobBookmarksEncryption;
        software.amazon.awscdk.services.glue.alpha.S3Encryption s3Encryption;
        java.lang.String securityConfigurationName;

        /**
         * Sets the value of {@link SecurityConfigurationProps#getCloudWatchEncryption}
         * @param cloudWatchEncryption The encryption configuration for Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudWatchEncryption(software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getJobBookmarksEncryption}
         * @param jobBookmarksEncryption The encryption configuration for Glue Job Bookmarks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobBookmarksEncryption(software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getS3Encryption}
         * @param s3Encryption The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Encryption(software.amazon.awscdk.services.glue.alpha.S3Encryption s3Encryption) {
            this.s3Encryption = s3Encryption;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getSecurityConfigurationName}
         * @param securityConfigurationName The name of the security configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfigurationName(java.lang.String securityConfigurationName) {
            this.securityConfigurationName = securityConfigurationName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SecurityConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityConfigurationProps {
        private final software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption cloudWatchEncryption;
        private final software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption jobBookmarksEncryption;
        private final software.amazon.awscdk.services.glue.alpha.S3Encryption s3Encryption;
        private final java.lang.String securityConfigurationName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cloudWatchEncryption = software.amazon.jsii.Kernel.get(this, "cloudWatchEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption.class));
            this.jobBookmarksEncryption = software.amazon.jsii.Kernel.get(this, "jobBookmarksEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption.class));
            this.s3Encryption = software.amazon.jsii.Kernel.get(this, "s3Encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.S3Encryption.class));
            this.securityConfigurationName = software.amazon.jsii.Kernel.get(this, "securityConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cloudWatchEncryption = builder.cloudWatchEncryption;
            this.jobBookmarksEncryption = builder.jobBookmarksEncryption;
            this.s3Encryption = builder.s3Encryption;
            this.securityConfigurationName = builder.securityConfigurationName;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.CloudWatchEncryption getCloudWatchEncryption() {
            return this.cloudWatchEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.JobBookmarksEncryption getJobBookmarksEncryption() {
            return this.jobBookmarksEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.S3Encryption getS3Encryption() {
            return this.s3Encryption;
        }

        @Override
        public final java.lang.String getSecurityConfigurationName() {
            return this.securityConfigurationName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCloudWatchEncryption() != null) {
                data.set("cloudWatchEncryption", om.valueToTree(this.getCloudWatchEncryption()));
            }
            if (this.getJobBookmarksEncryption() != null) {
                data.set("jobBookmarksEncryption", om.valueToTree(this.getJobBookmarksEncryption()));
            }
            if (this.getS3Encryption() != null) {
                data.set("s3Encryption", om.valueToTree(this.getS3Encryption()));
            }
            if (this.getSecurityConfigurationName() != null) {
                data.set("securityConfigurationName", om.valueToTree(this.getSecurityConfigurationName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue-alpha.SecurityConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityConfigurationProps.Jsii$Proxy that = (SecurityConfigurationProps.Jsii$Proxy) o;

            if (this.cloudWatchEncryption != null ? !this.cloudWatchEncryption.equals(that.cloudWatchEncryption) : that.cloudWatchEncryption != null) return false;
            if (this.jobBookmarksEncryption != null ? !this.jobBookmarksEncryption.equals(that.jobBookmarksEncryption) : that.jobBookmarksEncryption != null) return false;
            if (this.s3Encryption != null ? !this.s3Encryption.equals(that.s3Encryption) : that.s3Encryption != null) return false;
            return this.securityConfigurationName != null ? this.securityConfigurationName.equals(that.securityConfigurationName) : that.securityConfigurationName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cloudWatchEncryption != null ? this.cloudWatchEncryption.hashCode() : 0;
            result = 31 * result + (this.jobBookmarksEncryption != null ? this.jobBookmarksEncryption.hashCode() : 0);
            result = 31 * result + (this.s3Encryption != null ? this.s3Encryption.hashCode() : 0);
            result = 31 * result + (this.securityConfigurationName != null ? this.securityConfigurationName.hashCode() : 0);
            return result;
        }
    }
}
