package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) A storage parameter. The list of storage parameters available is not exhaustive and other keys may be used.
 * <p>
 * If you would like to specify a storage parameter that is not available as a static member of this class, use the <code>StorageParameter.custom</code> method.
 * <p>
 * The list of storage parameters currently known within the CDK is listed.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * S3Table.Builder.create(this, "MyTable")
 *         .storageParameters(List.of(StorageParameter.skipHeaderLineCount(1), StorageParameter.compressionType(CompressionType.GZIP), StorageParameter.custom("separatorChar", ",")))
 *         // ...
 *         .database(myDatabase)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_">https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.255Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.StorageParameter")
public class StorageParameter extends software.amazon.jsii.JsiiObject {

    protected StorageParameter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StorageParameter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param key This parameter is required.
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected StorageParameter(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Identifies if the file contains less or more values for a row than the number of columns specified in the external table definition.
     * <p>
     * This property is only available for an uncompressed text file format.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter columnCountMismatchHandling(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.ColumnCountMismatchHandlingAction value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "columnCountMismatchHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) The type of compression used on the table, when the file name does not contain an extension.
     * <p>
     * This value overrides the compression type specified through the extension.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter compressionType(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.CompressionType value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "compressionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A custom storage parameter.
     * <p>
     * @param key <ul><li>The key of the storage parameter.</li></ul> This parameter is required.
     * @param value <ul><li>The value of the storage parameter.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter custom(final @org.jetbrains.annotations.NotNull java.lang.String key, final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), value });
    }

    /**
     * (experimental) Determines whether data handling is on for the table.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter dataCleansingEnabled(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "dataCleansingEnabled", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Specifies the action to perform when query results contain invalid UTF-8 character values.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter invalidCharHandling(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.InvalidCharHandlingAction value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "invalidCharHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Specifies the action to perform when ORC data contains an integer (for example, BIGINT or int64) that is larger than the column definition (for example, SMALLINT or int16).
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter numericOverflowHandling(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.NumericOverflowHandlingAction value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "numericOverflowHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A property that sets the numRows value for the table definition.
     * <p>
     * To explicitly update an external table's statistics, set the numRows property to indicate the size of the table. Amazon Redshift doesn't analyze external tables to generate the table statistics that the query optimizer uses to generate a query plan. If table statistics aren't set for an external table, Amazon Redshift generates a query execution plan based on an assumption that external tables are the larger tables and local tables are the smaller tables.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter numRows(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "numRows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A property that sets the column mapping type for tables that use ORC data format.
     * <p>
     * This property is ignored for other data formats. If this property is omitted, columns are mapped by <code>OrcColumnMappingType.NAME</code> by default.
     * <p>
     * Default: OrcColumnMappingType.NAME
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter orcSchemaResolution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.OrcColumnMappingType value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "orcSchemaResolution", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Specifies the replacement character to use when you set <code>INVALID_CHAR_HANDLING</code> to <code>REPLACE</code>.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter replacementChar(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "replacementChar", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A property that sets number of rows to skip at the beginning of each source file.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter serializationNullFormat(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "serializationNullFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) The number of rows to skip at the top of a CSV file when the table is being created.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter skipHeaderLineCount(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "skipHeaderLineCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Specifies how to handle data being loaded that exceeds the length of the data type defined for columns containing VARBYTE data.
     * <p>
     * By default, Redshift Spectrum sets the value to null for data that exceeds the width of the column.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter surplusBytesHandling(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.SurplusBytesHandlingAction value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "surplusBytesHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) Specifies how to handle data being loaded that exceeds the length of the data type defined for columns containing VARCHAR, CHAR, or string data.
     * <p>
     * By default, Redshift Spectrum sets the value to null for data that exceeds the width of the column.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter surplusCharHandling(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.SurplusCharHandlingAction value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "surplusCharHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) You can specify an AWS Key Management Service key to enable Server–Side Encryption (SSE) for Amazon S3 objects.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter writeKmsKeyId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "writeKmsKeyId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A property that sets the maximum size (in MB) of each file written to Amazon S3 by CREATE EXTERNAL TABLE AS.
     * <p>
     * The size must be a valid integer between 5 and 6200. The default maximum file size is 6,200 MB. This table property also applies to any subsequent INSERT statement into the same external table.
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter writeMaxFileSizeMb(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "writeMaxFileSizeMb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * (experimental) A property that sets whether CREATE EXTERNAL TABLE AS should write data in parallel.
     * <p>
     * When 'write.parallel' is set to off, CREATE EXTERNAL TABLE AS writes to one or more data files serially onto Amazon S3. This table property also applies to any subsequent INSERT statement into the same external table.
     * <p>
     * Default: WriteParallel.ON
     * <p>
     * @param value This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.StorageParameter writeParallel(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.WriteParallel value) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.StorageParameter.class, "writeParallel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class), new Object[] { java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getKey() {
        return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
