package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) The storage parameter keys that are currently known, this list is not exhaustive and other keys may be used.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IDatabase glueDatabase;
 * Table table = Table.Builder.create(this, "Table")
 *         .storageParameters(List.of(StorageParameter.skipHeaderLineCount(1), StorageParameter.compressionType(CompressionType.GZIP), StorageParameter.custom("foo", "bar"), StorageParameter.custom("separatorChar", ","), StorageParameter.custom(StorageParameters.WRITE_PARALLEL, "off")))
 *         // ...
 *         .database(glueDatabase)
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .dataFormat(DataFormat.CSV)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.256Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.StorageParameters")
public enum StorageParameters {
    /**
     * (experimental) The number of rows to skip at the top of a CSV file when the table is being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SKIP_HEADER_LINE_COUNT,
    /**
     * (experimental) Determines whether data handling is on for the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DATA_CLEANSING_ENABLED,
    /**
     * (experimental) The type of compression used on the table, when the file name does not contain an extension.
     * <p>
     * This value overrides the compression type specified through the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COMPRESSION_TYPE,
    /**
     * (experimental) Specifies the action to perform when query results contain invalid UTF-8 character values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    INVALID_CHAR_HANDLING,
    /**
     * (experimental) Specifies the replacement character to use when you set <code>INVALID_CHAR_HANDLING</code> to <code>REPLACE</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    REPLACEMENT_CHAR,
    /**
     * (experimental) Specifies the action to perform when ORC data contains an integer (for example, BIGINT or int64) that is larger than the column definition (for example, SMALLINT or int16).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NUMERIC_OVERFLOW_HANDLING,
    /**
     * (experimental) Specifies how to handle data being loaded that exceeds the length of the data type defined for columns containing VARBYTE data.
     * <p>
     * By default, Redshift Spectrum sets the value to null for data that exceeds the width of the column.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SURPLUS_BYTES_HANDLING,
    /**
     * (experimental) Specifies how to handle data being loaded that exceeds the length of the data type defined for columns containing VARCHAR, CHAR, or string data.
     * <p>
     * By default, Redshift Spectrum sets the value to null for data that exceeds the width of the column.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SURPLUS_CHAR_HANDLING,
    /**
     * (experimental) Identifies if the file contains less or more values for a row than the number of columns specified in the external table definition.
     * <p>
     * This property is only available for an uncompressed text file format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    COLUMN_COUNT_MISMATCH_HANDLING,
    /**
     * (experimental) A property that sets the numRows value for the table definition.
     * <p>
     * To explicitly update an external table's statistics, set the numRows property to indicate the size of the table. Amazon Redshift doesn't analyze external tables to generate the table statistics that the query optimizer uses to generate a query plan. If table statistics aren't set for an external table, Amazon Redshift generates a query execution plan based on an assumption that external tables are the larger tables and local tables are the smaller tables.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    NUM_ROWS,
    /**
     * (experimental) A property that sets number of rows to skip at the beginning of each source file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SERIALIZATION_NULL_FORMAT,
    /**
     * (experimental) A property that sets the column mapping type for tables that use ORC data format.
     * <p>
     * This property is ignored for other data formats.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    ORC_SCHEMA_RESOLUTION,
    /**
     * (experimental) A property that sets whether CREATE EXTERNAL TABLE AS should write data in parallel.
     * <p>
     * When 'write.parallel' is set to off, CREATE EXTERNAL TABLE AS writes to one or more data files serially onto Amazon S3. This table property also applies to any subsequent INSERT statement into the same external table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WRITE_PARALLEL,
    /**
     * (experimental) A property that sets the maximum size (in MB) of each file written to Amazon S3 by CREATE EXTERNAL TABLE AS.
     * <p>
     * The size must be a valid integer between 5 and 6200. The default maximum file size is 6,200 MB. This table property also applies to any subsequent INSERT statement into the same external table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WRITE_MAX_FILESIZE_MB,
    /**
     * (experimental) You can specify an AWS Key Management Service key to enable Server–Side Encryption (SSE) for Amazon S3 objects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    WRITE_KMS_KEY_ID,
}
