package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) Specifies how to handle data being loaded that exceeds the length of the data type defined for columns containing VARCHAR, CHAR, or string data.
 * <p>
 * By default, Redshift Spectrum sets the value to null for data that exceeds the width of the column.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;surplus_char_handling&#34;_">https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_EXTERNAL_TABLE.html#r_CREATE_EXTERNAL_TABLE-parameters - under _&#34;TABLE PROPERTIES&#34;_ &#62; _&#34;surplus_char_handling&#34;_</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.256Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.SurplusCharHandlingAction")
public enum SurplusCharHandlingAction {
    /**
     * (experimental) Replaces data that exceeds the column width with null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    SET_TO_NULL,
    /**
     * (experimental) Doesn't perform surplus character handling.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DISABLED,
    /**
     * (experimental) Cancels queries that return data exceeding the column width.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    FAIL,
    /**
     * (experimental) Replaces each value in the row with null.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    DROP_ROW,
    /**
     * (experimental) Removes the characters that exceed the maximum number of characters defined for the column.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    TRUNCATE,
}
