package software.amazon.awscdk.services.glue.alpha;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.alpha.*;
 * import software.amazon.awscdk.services.kms.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * Database database;
 * DataFormat dataFormat;
 * Key key;
 * StorageParameter storageParameter;
 * TableProps tableProps = TableProps.builder()
 *         .columns(List.of(Column.builder()
 *                 .name("name")
 *                 .type(Type.builder()
 *                         .inputString("inputString")
 *                         .isPrimitive(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build()))
 *         .database(database)
 *         .dataFormat(dataFormat)
 *         // the properties below are optional
 *         .bucket(bucket)
 *         .compressed(false)
 *         .description("description")
 *         .enablePartitionFiltering(false)
 *         .encryption(TableEncryption.S3_MANAGED)
 *         .encryptionKey(key)
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .partitionIndexes(List.of(PartitionIndex.builder()
 *                 .keyNames(List.of("keyNames"))
 *                 // the properties below are optional
 *                 .indexName("indexName")
 *                 .build()))
 *         .partitionKeys(List.of(Column.builder()
 *                 .name("name")
 *                 .type(Type.builder()
 *                         .inputString("inputString")
 *                         .isPrimitive(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .comment("comment")
 *                 .build()))
 *         .s3Prefix("s3Prefix")
 *         .storageParameters(List.of(storageParameter))
 *         .storedAsSubDirectories(false)
 *         .tableName("tableName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.260Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.TableProps")
@software.amazon.jsii.Jsii.Proxy(TableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface TableProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.glue.alpha.S3TableProps {

    /**
     * @return a {@link Builder} of {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<TableProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        software.amazon.awscdk.services.glue.alpha.TableEncryption encryption;
        software.amazon.awscdk.services.kms.IKey encryptionKey;
        java.lang.String s3Prefix;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Column> columns;
        software.amazon.awscdk.services.glue.alpha.IDatabase database;
        software.amazon.awscdk.services.glue.alpha.DataFormat dataFormat;
        java.lang.Boolean compressed;
        java.lang.String description;
        java.lang.Boolean enablePartitionFiltering;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex> partitionIndexes;
        java.util.List<software.amazon.awscdk.services.glue.alpha.Column> partitionKeys;
        java.util.List<software.amazon.awscdk.services.glue.alpha.StorageParameter> storageParameters;
        java.lang.Boolean storedAsSubDirectories;
        java.lang.String tableName;

        /**
         * Sets the value of {@link TableProps#getBucket}
         * @param bucket S3 bucket in which to store data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryption}
         * @param encryption The kind of encryption to secure the data with.
         *                   You can only provide this option if you are not explicitly passing in a bucket.
         *                   <p>
         *                   If you choose <code>SSE-KMS</code>, you <em>can</em> provide an un-managed KMS key with <code>encryptionKey</code>.
         *                   If you choose <code>CSE-KMS</code>, you <em>must</em> provide an un-managed KMS key with <code>encryptionKey</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryption(software.amazon.awscdk.services.glue.alpha.TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEncryptionKey}
         * @param encryptionKey External KMS key to use for bucket encryption.
         *                      The <code>encryption</code> property must be <code>SSE-KMS</code> or <code>CSE-KMS</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getS3Prefix}
         * @param s3Prefix S3 prefix under which table objects are stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Prefix(java.lang.String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getColumns}
         * @param columns Columns of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder columns(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Column> columns) {
            this.columns = (java.util.List<software.amazon.awscdk.services.glue.alpha.Column>)columns;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDatabase}
         * @param database Database in which to store the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder database(software.amazon.awscdk.services.glue.alpha.IDatabase database) {
            this.database = database;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDataFormat}
         * @param dataFormat Storage type of the table's data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataFormat(software.amazon.awscdk.services.glue.alpha.DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getCompressed}
         * @param compressed Indicates whether the table's data is compressed or not.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder compressed(java.lang.Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getDescription}
         * @param description Description of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getEnablePartitionFiltering}
         * @param enablePartitionFiltering Enables partition filtering.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enablePartitionFiltering(java.lang.Boolean enablePartitionFiltering) {
            this.enablePartitionFiltering = enablePartitionFiltering;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getParameters}
         * @param parameters The key/value pairs define properties associated with the table.
         *                   The key/value pairs that are allowed to be submitted are not limited, however their functionality is not guaranteed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionIndexes}
         * @param partitionIndexes Partition indexes on the table.
         *                         A maximum of 3 indexes
         *                         are allowed on a table. Keys in the index must be part
         *                         of the table's partition keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder partitionIndexes(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.PartitionIndex> partitionIndexes) {
            this.partitionIndexes = (java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex>)partitionIndexes;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getPartitionKeys}
         * @param partitionKeys Partition columns of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder partitionKeys(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.Column> partitionKeys) {
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.glue.alpha.Column>)partitionKeys;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getStorageParameters}
         * @param storageParameters The user-supplied properties for the description of the physical storage of this table.
         *                          These properties help describe the format of the data that is stored within the crawled data sources.
         *                          <p>
         *                          The key/value pairs that are allowed to be submitted are not limited, however their functionality is not guaranteed.
         *                          <p>
         *                          Some keys will be auto-populated by glue crawlers, however, you can override them by specifying the key and value in this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder storageParameters(java.util.List<? extends software.amazon.awscdk.services.glue.alpha.StorageParameter> storageParameters) {
            this.storageParameters = (java.util.List<software.amazon.awscdk.services.glue.alpha.StorageParameter>)storageParameters;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getStoredAsSubDirectories}
         * @param storedAsSubDirectories Indicates whether the table data is stored in subdirectories.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder storedAsSubDirectories(java.lang.Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        /**
         * Sets the value of {@link TableProps#getTableName}
         * @param tableName Name of the table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public TableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TableProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final software.amazon.awscdk.services.glue.alpha.TableEncryption encryption;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.lang.String s3Prefix;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Column> columns;
        private final software.amazon.awscdk.services.glue.alpha.IDatabase database;
        private final software.amazon.awscdk.services.glue.alpha.DataFormat dataFormat;
        private final java.lang.Boolean compressed;
        private final java.lang.String description;
        private final java.lang.Boolean enablePartitionFiltering;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex> partitionIndexes;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.Column> partitionKeys;
        private final java.util.List<software.amazon.awscdk.services.glue.alpha.StorageParameter> storageParameters;
        private final java.lang.Boolean storedAsSubDirectories;
        private final java.lang.String tableName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.TableEncryption.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.columns = software.amazon.jsii.Kernel.get(this, "columns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Column.class)));
            this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.IDatabase.class));
            this.dataFormat = software.amazon.jsii.Kernel.get(this, "dataFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.DataFormat.class));
            this.compressed = software.amazon.jsii.Kernel.get(this, "compressed", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enablePartitionFiltering = software.amazon.jsii.Kernel.get(this, "enablePartitionFiltering", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.partitionIndexes = software.amazon.jsii.Kernel.get(this, "partitionIndexes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.PartitionIndex.class)));
            this.partitionKeys = software.amazon.jsii.Kernel.get(this, "partitionKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.Column.class)));
            this.storageParameters = software.amazon.jsii.Kernel.get(this, "storageParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.StorageParameter.class)));
            this.storedAsSubDirectories = software.amazon.jsii.Kernel.get(this, "storedAsSubDirectories", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = builder.bucket;
            this.encryption = builder.encryption;
            this.encryptionKey = builder.encryptionKey;
            this.s3Prefix = builder.s3Prefix;
            this.columns = (java.util.List<software.amazon.awscdk.services.glue.alpha.Column>)java.util.Objects.requireNonNull(builder.columns, "columns is required");
            this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
            this.dataFormat = java.util.Objects.requireNonNull(builder.dataFormat, "dataFormat is required");
            this.compressed = builder.compressed;
            this.description = builder.description;
            this.enablePartitionFiltering = builder.enablePartitionFiltering;
            this.parameters = builder.parameters;
            this.partitionIndexes = (java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex>)builder.partitionIndexes;
            this.partitionKeys = (java.util.List<software.amazon.awscdk.services.glue.alpha.Column>)builder.partitionKeys;
            this.storageParameters = (java.util.List<software.amazon.awscdk.services.glue.alpha.StorageParameter>)builder.storageParameters;
            this.storedAsSubDirectories = builder.storedAsSubDirectories;
            this.tableName = builder.tableName;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.TableEncryption getEncryption() {
            return this.encryption;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.lang.String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Column> getColumns() {
            return this.columns;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.IDatabase getDatabase() {
            return this.database;
        }

        @Override
        public final software.amazon.awscdk.services.glue.alpha.DataFormat getDataFormat() {
            return this.dataFormat;
        }

        @Override
        public final java.lang.Boolean getCompressed() {
            return this.compressed;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Boolean getEnablePartitionFiltering() {
            return this.enablePartitionFiltering;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.PartitionIndex> getPartitionIndexes() {
            return this.partitionIndexes;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.Column> getPartitionKeys() {
            return this.partitionKeys;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.alpha.StorageParameter> getStorageParameters() {
            return this.storageParameters;
        }

        @Override
        public final java.lang.Boolean getStoredAsSubDirectories() {
            return this.storedAsSubDirectories;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getEncryption() != null) {
                data.set("encryption", om.valueToTree(this.getEncryption()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getS3Prefix() != null) {
                data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
            }
            data.set("columns", om.valueToTree(this.getColumns()));
            data.set("database", om.valueToTree(this.getDatabase()));
            data.set("dataFormat", om.valueToTree(this.getDataFormat()));
            if (this.getCompressed() != null) {
                data.set("compressed", om.valueToTree(this.getCompressed()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnablePartitionFiltering() != null) {
                data.set("enablePartitionFiltering", om.valueToTree(this.getEnablePartitionFiltering()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getPartitionIndexes() != null) {
                data.set("partitionIndexes", om.valueToTree(this.getPartitionIndexes()));
            }
            if (this.getPartitionKeys() != null) {
                data.set("partitionKeys", om.valueToTree(this.getPartitionKeys()));
            }
            if (this.getStorageParameters() != null) {
                data.set("storageParameters", om.valueToTree(this.getStorageParameters()));
            }
            if (this.getStoredAsSubDirectories() != null) {
                data.set("storedAsSubDirectories", om.valueToTree(this.getStoredAsSubDirectories()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue-alpha.TableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TableProps.Jsii$Proxy that = (TableProps.Jsii$Proxy) o;

            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.s3Prefix != null ? !this.s3Prefix.equals(that.s3Prefix) : that.s3Prefix != null) return false;
            if (!columns.equals(that.columns)) return false;
            if (!database.equals(that.database)) return false;
            if (!dataFormat.equals(that.dataFormat)) return false;
            if (this.compressed != null ? !this.compressed.equals(that.compressed) : that.compressed != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.enablePartitionFiltering != null ? !this.enablePartitionFiltering.equals(that.enablePartitionFiltering) : that.enablePartitionFiltering != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.partitionIndexes != null ? !this.partitionIndexes.equals(that.partitionIndexes) : that.partitionIndexes != null) return false;
            if (this.partitionKeys != null ? !this.partitionKeys.equals(that.partitionKeys) : that.partitionKeys != null) return false;
            if (this.storageParameters != null ? !this.storageParameters.equals(that.storageParameters) : that.storageParameters != null) return false;
            if (this.storedAsSubDirectories != null ? !this.storedAsSubDirectories.equals(that.storedAsSubDirectories) : that.storedAsSubDirectories != null) return false;
            return this.tableName != null ? this.tableName.equals(that.tableName) : that.tableName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket != null ? this.bucket.hashCode() : 0;
            result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.s3Prefix != null ? this.s3Prefix.hashCode() : 0);
            result = 31 * result + (this.columns.hashCode());
            result = 31 * result + (this.database.hashCode());
            result = 31 * result + (this.dataFormat.hashCode());
            result = 31 * result + (this.compressed != null ? this.compressed.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.enablePartitionFiltering != null ? this.enablePartitionFiltering.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.partitionIndexes != null ? this.partitionIndexes.hashCode() : 0);
            result = 31 * result + (this.partitionKeys != null ? this.partitionKeys.hashCode() : 0);
            result = 31 * result + (this.storageParameters != null ? this.storageParameters.hashCode() : 0);
            result = 31 * result + (this.storedAsSubDirectories != null ? this.storedAsSubDirectories.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            return result;
        }
    }
}
