package software.amazon.awscdk.services.glue.alpha;

/**
 * (experimental) The type of predefined worker that is allocated when a job runs.
 * <p>
 * If you need to use a WorkerType that doesn't exist as a static member, you
 * can instantiate a <code>WorkerType</code> object, e.g: <code>WorkerType.of('other type')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "ScalaSparkEtlJob")
 *         .executable(JobExecutable.scalaEtl(ScalaJobExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V4_0)
 *                 .script(Code.fromBucket(bucket, "src/com/example/HelloWorld.scala"))
 *                 .className("com.example.HelloWorld")
 *                 .extraJars(List.of(Code.fromBucket(bucket, "jars/HelloWorld.jar")))
 *                 .build()))
 *         .workerType(WorkerType.G_8X)
 *         .description("an example Scala ETL job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.94.0 (build b380f01)", date = "2024-01-13T02:49:34.262Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.alpha.$Module.class, fqn = "@aws-cdk/aws-glue-alpha.WorkerType")
public class WorkerType extends software.amazon.jsii.JsiiObject {

    protected WorkerType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WorkerType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        G_025_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "G_025X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        G_1_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "G_1X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        G_2_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "G_2X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        G_4_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "G_4X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        G_8_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "G_8X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        STANDARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "STANDARD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
        Z_2_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "Z_2X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class));
    }

    /**
     * (experimental) Custom worker type.
     * <p>
     * @param workerType custom worker type. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.alpha.WorkerType of(final @org.jetbrains.annotations.NotNull java.lang.String workerType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.alpha.WorkerType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.alpha.WorkerType.class), new Object[] { java.util.Objects.requireNonNull(workerType, "workerType is required") });
    }

    /**
     * (experimental) Each worker maps to 0.25 DPU (2 vCPU, 4 GB of memory, 64 GB disk), and provides 1 executor per worker. Suitable for low volume streaming jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType G_025_X;

    /**
     * (experimental) Each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType G_1_X;

    /**
     * (experimental) Each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType G_2_X;

    /**
     * (experimental) Each worker maps to 4 DPU (16 vCPU, 64 GB of memory, 256 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType G_4_X;

    /**
     * (experimental) Each worker maps to 8 DPU (32 vCPU, 128 GB of memory, 512 GB disk), and provides 1 executor per worker.
     * <p>
     * We recommend this worker type for jobs whose workloads contain your most demanding transforms, aggregations, joins, and queries. This worker type is available only for AWS Glue version 3.0 or later jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType G_8_X;

    /**
     * (experimental) Each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType STANDARD;

    /**
     * (experimental) Each worker maps to 2 high-memory DPU [M-DPU] (8 vCPU, 64 GB of memory, 128 GB disk).
     * <p>
     * Supported in Ray jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.alpha.WorkerType Z_2_X;

    /**
     * (experimental) The name of this WorkerType, as expected by Job resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
