/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue.alpha;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.glue.alpha.$Module;
import software.amazon.awscdk.services.glue.alpha.ConnectionProps;
import software.amazon.awscdk.services.glue.alpha.ConnectionType;
import software.amazon.awscdk.services.glue.alpha.IConnection;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-glue-alpha.Connection")
public class Connection
extends Resource
implements IConnection {
    protected Connection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Connection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Connection(@NotNull Construct scope, @NotNull String id, @NotNull ConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IConnection fromConnectionArn(@NotNull Construct scope, @NotNull String id, @NotNull String connectionArn) {
        return (IConnection)JsiiObject.jsiiStaticCall(Connection.class, (String)"fromConnectionArn", (NativeType)NativeType.forClass(IConnection.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(connectionArn, "connectionArn is required")});
    }

    @NotNull
    public static IConnection fromConnectionName(@NotNull Construct scope, @NotNull String id, @NotNull String connectionName) {
        return (IConnection)JsiiObject.jsiiStaticCall(Connection.class, (String)"fromConnectionName", (NativeType)NativeType.forClass(IConnection.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(connectionName, "connectionName is required")});
    }

    public void addProperty(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"addProperty", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @Override
    @NotNull
    public String getConnectionArn() {
        return (String)Kernel.get((Object)this, (String)"connectionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getConnectionName() {
        return (String)Kernel.get((Object)this, (String)"connectionName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Connection> {
        private final Construct scope;
        private final String id;
        private final ConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ConnectionProps.Builder();
        }

        public Builder connectionName(String connectionName) {
            this.props.connectionName(connectionName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder matchCriteria(List<String> matchCriteria) {
            this.props.matchCriteria(matchCriteria);
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.props.properties(properties);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder subnet(ISubnet subnet) {
            this.props.subnet(subnet);
            return this;
        }

        public Builder type(ConnectionType type) {
            this.props.type(type);
            return this;
        }

        public Connection build() {
            return new Connection(this.scope, this.id, this.props.build());
        }
    }
}

