/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue.alpha;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.glue.CfnTable;
import software.amazon.awscdk.services.glue.alpha.;
import software.amazon.awscdk.services.glue.alpha.Column;
import software.amazon.awscdk.services.glue.alpha.DataFormat;
import software.amazon.awscdk.services.glue.alpha.ExternalTableProps;
import software.amazon.awscdk.services.glue.alpha.IConnection;
import software.amazon.awscdk.services.glue.alpha.IDatabase;
import software.amazon.awscdk.services.glue.alpha.PartitionIndex;
import software.amazon.awscdk.services.glue.alpha.StorageParameter;
import software.amazon.awscdk.services.glue.alpha.TableBase;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-glue-alpha.ExternalTable")
public class ExternalTable
extends TableBase {
    protected ExternalTable(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ExternalTable(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ExternalTable(@NotNull Construct scope, @NotNull String id, @NotNull ExternalTableProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantReadWrite(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantReadWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)Kernel.call((Object)this, (String)"grantWrite", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @NotNull
    public IConnection getConnection() {
        return (IConnection)Kernel.get((Object)this, (String)"connection", (NativeType)NativeType.forClass(IConnection.class));
    }

    @Override
    @NotNull
    public String getTableArn() {
        return (String)Kernel.get((Object)this, (String)"tableArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getTableName() {
        return (String)Kernel.get((Object)this, (String)"tableName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected CfnTable getTableResource() {
        return (CfnTable)Kernel.get((Object)this, (String)"tableResource", (NativeType)NativeType.forClass(CfnTable.class));
    }

    @Override
    @Nullable
    public List<PartitionIndex> getPartitionIndexes() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"partitionIndexes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PartitionIndex.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ExternalTable> {
        private final Construct scope;
        private final String id;
        private final ExternalTableProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ExternalTableProps.Builder();
        }

        public Builder columns(List<? extends Column> columns) {
            this.props.columns(columns);
            return this;
        }

        public Builder database(IDatabase database) {
            this.props.database(database);
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.props.dataFormat(dataFormat);
            return this;
        }

        public Builder compressed(Boolean compressed) {
            this.props.compressed(compressed);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enablePartitionFiltering(Boolean enablePartitionFiltering) {
            this.props.enablePartitionFiltering(enablePartitionFiltering);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder partitionIndexes(List<? extends PartitionIndex> partitionIndexes) {
            this.props.partitionIndexes(partitionIndexes);
            return this;
        }

        public Builder partitionKeys(List<? extends Column> partitionKeys) {
            this.props.partitionKeys(partitionKeys);
            return this;
        }

        public Builder storageParameters(List<? extends StorageParameter> storageParameters) {
            this.props.storageParameters(storageParameters);
            return this;
        }

        public Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.props.storedAsSubDirectories(storedAsSubDirectories);
            return this;
        }

        public Builder tableName(String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        public Builder connection(IConnection connection) {
            this.props.connection(connection);
            return this;
        }

        public Builder externalDataLocation(String externalDataLocation) {
            this.props.externalDataLocation(externalDataLocation);
            return this;
        }

        public ExternalTable build() {
            return new ExternalTable(this.scope, this.id, this.props.build());
        }
    }
}

