/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue.alpha;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.glue.alpha.;
import software.amazon.awscdk.services.glue.alpha.Column;
import software.amazon.awscdk.services.glue.alpha.DataFormat;
import software.amazon.awscdk.services.glue.alpha.IDatabase;
import software.amazon.awscdk.services.glue.alpha.PartitionIndex;
import software.amazon.awscdk.services.glue.alpha.S3TableProps;
import software.amazon.awscdk.services.glue.alpha.StorageParameter;
import software.amazon.awscdk.services.glue.alpha.TableBaseProps;
import software.amazon.awscdk.services.glue.alpha.TableEncryption;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-glue-alpha.S3TableProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface S3TableProps
extends JsiiSerializable,
TableBaseProps {
    @Nullable
    default public IBucket getBucket() {
        return null;
    }

    @Nullable
    default public TableEncryption getEncryption() {
        return null;
    }

    @Nullable
    default public IKey getEncryptionKey() {
        return null;
    }

    @Nullable
    default public String getS3Prefix() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3TableProps> {
        IBucket bucket;
        TableEncryption encryption;
        IKey encryptionKey;
        String s3Prefix;
        List<Column> columns;
        IDatabase database;
        DataFormat dataFormat;
        Boolean compressed;
        String description;
        Boolean enablePartitionFiltering;
        Map<String, String> parameters;
        List<PartitionIndex> partitionIndexes;
        List<Column> partitionKeys;
        List<StorageParameter> storageParameters;
        Boolean storedAsSubDirectories;
        String tableName;

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public Builder columns(List<? extends Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder database(IDatabase database) {
            this.database = database;
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder enablePartitionFiltering(Boolean enablePartitionFiltering) {
            this.enablePartitionFiltering = enablePartitionFiltering;
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder partitionIndexes(List<? extends PartitionIndex> partitionIndexes) {
            this.partitionIndexes = partitionIndexes;
            return this;
        }

        public Builder partitionKeys(List<? extends Column> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder storageParameters(List<? extends StorageParameter> storageParameters) {
            this.storageParameters = storageParameters;
            return this;
        }

        public Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public S3TableProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

