/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue.alpha;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.glue.CfnTable;
import software.amazon.awscdk.services.glue.alpha.;
import software.amazon.awscdk.services.glue.alpha.Column;
import software.amazon.awscdk.services.glue.alpha.DataFormat;
import software.amazon.awscdk.services.glue.alpha.IDatabase;
import software.amazon.awscdk.services.glue.alpha.ITable;
import software.amazon.awscdk.services.glue.alpha.PartitionIndex;
import software.amazon.awscdk.services.glue.alpha.StorageParameter;
import software.amazon.awscdk.services.glue.alpha.TableAttributes;
import software.amazon.awscdk.services.glue.alpha.TableBaseProps;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-glue-alpha.TableBase")
public abstract class TableBase
extends Resource
implements ITable {
    protected TableBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected TableBase(@NotNull Construct scope, @NotNull String id, @NotNull TableBaseProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ITable fromTableArn(@NotNull Construct scope, @NotNull String id, @NotNull String tableArn) {
        return (ITable)JsiiObject.jsiiStaticCall(TableBase.class, (String)"fromTableArn", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(tableArn, "tableArn is required")});
    }

    @NotNull
    public static ITable fromTableAttributes(@NotNull Construct scope, @NotNull String id, @NotNull TableAttributes attrs) {
        return (ITable)JsiiObject.jsiiStaticCall(TableBase.class, (String)"fromTableAttributes", (NativeType)NativeType.forClass(ITable.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addPartitionIndex(@NotNull PartitionIndex index) {
        Kernel.call((Object)this, (String)"addPartitionIndex", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(index, "index is required")});
    }

    @NotNull
    public Grant grant(@NotNull IGrantable grantee, @NotNull List<String> actions) {
        return (Grant)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(actions, "actions is required")});
    }

    @NotNull
    public abstract Grant grantRead(@NotNull IGrantable var1);

    @NotNull
    public abstract Grant grantReadWrite(@NotNull IGrantable var1);

    @NotNull
    public Grant grantToUnderlyingResources(@NotNull IGrantable grantee, @NotNull List<String> actions) {
        return (Grant)Kernel.call((Object)this, (String)"grantToUnderlyingResources", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(actions, "actions is required")});
    }

    @NotNull
    public abstract Grant grantWrite(@NotNull IGrantable var1);

    @NotNull
    public List<Column> getColumns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"columns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Column.class))));
    }

    @NotNull
    public Boolean getCompressed() {
        return (Boolean)Kernel.get((Object)this, (String)"compressed", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public IDatabase getDatabase() {
        return (IDatabase)Kernel.get((Object)this, (String)"database", (NativeType)NativeType.forClass(IDatabase.class));
    }

    @NotNull
    public DataFormat getDataFormat() {
        return (DataFormat)((Object)Kernel.get((Object)this, (String)"dataFormat", (NativeType)NativeType.forClass(DataFormat.class)));
    }

    @NotNull
    protected Map<String, String> getParameters() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public abstract String getTableArn();

    @Override
    @NotNull
    public abstract String getTableName();

    @NotNull
    protected abstract CfnTable getTableResource();

    @Nullable
    public abstract List<PartitionIndex> getPartitionIndexes();

    @Nullable
    public List<Column> getPartitionKeys() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"partitionKeys", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Column.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Nullable
    public List<StorageParameter> getStorageParameters() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"storageParameters", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(StorageParameter.class)))).map(Collections::unmodifiableList).orElse(null);
    }
}

