package software.amazon.awscdk.services.glue;

/**
 * (experimental) Construction properties for {@link Connection}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * Connection.Builder.create(this, "MyConnection")
 *         .type(ConnectionType.NETWORK)
 *         // The security groups granting AWS Glue inbound access to the data source within the VPC
 *         .securityGroups(List.of(securityGroup))
 *         // The VPC subnet which contains the data source
 *         .subnet(subnet)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.444Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.ConnectionProps")
@software.amazon.jsii.Jsii.Proxy(ConnectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ConnectionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.glue.ConnectionOptions {

    /**
     * (experimental) The type of the connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.ConnectionType getType();

    /**
     * @return a {@link Builder} of {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ConnectionProps> {
        software.amazon.awscdk.services.glue.ConnectionType type;
        java.lang.String connectionName;
        java.lang.String description;
        java.util.List<java.lang.String> matchCriteria;
        java.util.Map<java.lang.String, java.lang.String> properties;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        software.amazon.awscdk.services.ec2.ISubnet subnet;

        /**
         * Sets the value of {@link ConnectionProps#getType}
         * @param type The type of the connection. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(software.amazon.awscdk.services.glue.ConnectionType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getConnectionName}
         * @param connectionName The name of the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionName(java.lang.String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getDescription}
         * @param description The description of the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getMatchCriteria}
         * @param matchCriteria A list of criteria that can be used in selecting this connection.
         *                      This is useful for filtering the results of https://awscli.amazonaws.com/v2/documentation/api/latest/reference/glue/get-connections.html
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder matchCriteria(java.util.List<java.lang.String> matchCriteria) {
            this.matchCriteria = matchCriteria;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getProperties}
         * @param properties Key-Value pairs that define parameters for the connection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder properties(java.util.Map<java.lang.String, java.lang.String> properties) {
            this.properties = properties;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getSecurityGroups}
         * @param securityGroups The list of security groups needed to successfully make this connection e.g. to successfully connect to VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ConnectionProps#getSubnet}
         * @param subnet The VPC subnet to connect to resources within a VPC.
         *               See more at https://docs.aws.amazon.com/glue/latest/dg/start-connecting.html.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subnet(software.amazon.awscdk.services.ec2.ISubnet subnet) {
            this.subnet = subnet;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ConnectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ConnectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ConnectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionProps {
        private final software.amazon.awscdk.services.glue.ConnectionType type;
        private final java.lang.String connectionName;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> matchCriteria;
        private final java.util.Map<java.lang.String, java.lang.String> properties;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.ISubnet subnet;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ConnectionType.class));
            this.connectionName = software.amazon.jsii.Kernel.get(this, "connectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.matchCriteria = software.amazon.jsii.Kernel.get(this, "matchCriteria", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.subnet = software.amazon.jsii.Kernel.get(this, "subnet", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISubnet.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.connectionName = builder.connectionName;
            this.description = builder.description;
            this.matchCriteria = builder.matchCriteria;
            this.properties = builder.properties;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.subnet = builder.subnet;
        }

        @Override
        public final software.amazon.awscdk.services.glue.ConnectionType getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getConnectionName() {
            return this.connectionName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getMatchCriteria() {
            return this.matchCriteria;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getProperties() {
            return this.properties;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISubnet getSubnet() {
            return this.subnet;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getConnectionName() != null) {
                data.set("connectionName", om.valueToTree(this.getConnectionName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getMatchCriteria() != null) {
                data.set("matchCriteria", om.valueToTree(this.getMatchCriteria()));
            }
            if (this.getProperties() != null) {
                data.set("properties", om.valueToTree(this.getProperties()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnet() != null) {
                data.set("subnet", om.valueToTree(this.getSubnet()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue.ConnectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ConnectionProps.Jsii$Proxy that = (ConnectionProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.connectionName != null ? !this.connectionName.equals(that.connectionName) : that.connectionName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.matchCriteria != null ? !this.matchCriteria.equals(that.matchCriteria) : that.matchCriteria != null) return false;
            if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            return this.subnet != null ? this.subnet.equals(that.subnet) : that.subnet == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.connectionName != null ? this.connectionName.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.matchCriteria != null ? this.matchCriteria.hashCode() : 0);
            result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnet != null ? this.subnet.hashCode() : 0);
            return result;
        }
    }
}
