package software.amazon.awscdk.services.glue;

/**
 * (experimental) Defines the input/output formats and ser/de for a single DataFormat.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Database myDatabase;
 * Table.Builder.create(this, "MyTable")
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(List.of(Column.builder()
 *                 .name("col1")
 *                 .type(Schema.STRING)
 *                 .build()))
 *         .partitionKeys(List.of(Column.builder()
 *                 .name("year")
 *                 .type(Schema.SMALL_INT)
 *                 .build(), Column.builder()
 *                 .name("month")
 *                 .type(Schema.SMALL_INT)
 *                 .build()))
 *         .dataFormat(DataFormat.JSON)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.447Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.DataFormat")
public class DataFormat extends software.amazon.jsii.JsiiObject {

    protected DataFormat(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DataFormat(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        APACHE_LOGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "APACHE_LOGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        AVRO = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "AVRO", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        CLOUDTRAIL_LOGS = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "CLOUDTRAIL_LOGS", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        CSV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "CSV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        JSON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "JSON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        LOGSTASH = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "LOGSTASH", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        ORC = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "ORC", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        PARQUET = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "PARQUET", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
        TSV = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.DataFormat.class, "TSV", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.DataFormat.class));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DataFormat(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.DataFormatProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) DataFormat for Apache Web Server Logs.
     * <p>
     * Also works for CloudFront logs
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/apache.html">https://docs.aws.amazon.com/athena/latest/ug/apache.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat APACHE_LOGS;

    /**
     * (experimental) DataFormat for Apache Avro.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/avro.html">https://docs.aws.amazon.com/athena/latest/ug/avro.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat AVRO;

    /**
     * (experimental) DataFormat for CloudTrail logs stored on S3.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html">https://docs.aws.amazon.com/athena/latest/ug/cloudtrail.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat CLOUDTRAIL_LOGS;

    /**
     * (experimental) DataFormat for CSV Files.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/csv.html">https://docs.aws.amazon.com/athena/latest/ug/csv.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat CSV;

    /**
     * (experimental) Stored as plain text files in JSON format.
     * <p>
     * Uses OpenX Json SerDe for serialization and deseralization.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/json.html">https://docs.aws.amazon.com/athena/latest/ug/json.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat JSON;

    /**
     * (experimental) DataFormat for Logstash Logs, using the GROK SerDe.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/grok.html">https://docs.aws.amazon.com/athena/latest/ug/grok.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat LOGSTASH;

    /**
     * (experimental) DataFormat for Apache ORC (Optimized Row Columnar).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/orc.html">https://docs.aws.amazon.com/athena/latest/ug/orc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat ORC;

    /**
     * (experimental) DataFormat for Apache Parquet.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/parquet.html">https://docs.aws.amazon.com/athena/latest/ug/parquet.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat PARQUET;

    /**
     * (experimental) DataFormat for TSV (Tab-Separated Values).
     * <p>
     * @see <a href="https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html">https://docs.aws.amazon.com/athena/latest/ug/lazy-simple-serde.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.DataFormat TSV;

    /**
     * (experimental) `InputFormat` for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.InputFormat getInputFormat() {
        return software.amazon.jsii.Kernel.get(this, "inputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.InputFormat.class));
    }

    /**
     * (experimental) `OutputFormat` for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.OutputFormat getOutputFormat() {
        return software.amazon.jsii.Kernel.get(this, "outputFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.OutputFormat.class));
    }

    /**
     * (experimental) Serialization library for this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.SerializationLibrary getSerializationLibrary() {
        return software.amazon.jsii.Kernel.get(this, "serializationLibrary", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.SerializationLibrary.class));
    }

    /**
     * (experimental) Classification string given to tables with this data format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.ClassificationString getClassificationString() {
        return software.amazon.jsii.Kernel.get(this, "classificationString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ClassificationString.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.DataFormat}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.DataFormat> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.glue.DataFormatProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.glue.DataFormatProps.Builder();
        }

        /**
         * (experimental) `InputFormat` for this data format.
         * <p>
         * @return {@code this}
         * @param inputFormat `InputFormat` for this data format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder inputFormat(final software.amazon.awscdk.services.glue.InputFormat inputFormat) {
            this.props.inputFormat(inputFormat);
            return this;
        }

        /**
         * (experimental) `OutputFormat` for this data format.
         * <p>
         * @return {@code this}
         * @param outputFormat `OutputFormat` for this data format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputFormat(final software.amazon.awscdk.services.glue.OutputFormat outputFormat) {
            this.props.outputFormat(outputFormat);
            return this;
        }

        /**
         * (experimental) Serialization library for this data format.
         * <p>
         * @return {@code this}
         * @param serializationLibrary Serialization library for this data format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serializationLibrary(final software.amazon.awscdk.services.glue.SerializationLibrary serializationLibrary) {
            this.props.serializationLibrary(serializationLibrary);
            return this;
        }

        /**
         * (experimental) Classification string given to tables with this data format.
         * <p>
         * Default: - No classification is specified.
         * <p>
         * @return {@code this}
         * @param classificationString Classification string given to tables with this data format. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder classificationString(final software.amazon.awscdk.services.glue.ClassificationString classificationString) {
            this.props.classificationString(classificationString);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.glue.DataFormat}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.DataFormat build() {
            return new software.amazon.awscdk.services.glue.DataFormat(
                this.props.build()
            );
        }
    }
}
