package software.amazon.awscdk.services.glue;

/**
 * (experimental) Props for creating a Python shell job executable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * Job.Builder.create(this, "PythonShellJob")
 *         .executable(JobExecutable.pythonShell(PythonShellExecutableProps.builder()
 *                 .glueVersion(GlueVersion.V1_0)
 *                 .pythonVersion(PythonVersion.THREE)
 *                 .script(Code.fromBucket(bucket, "script.py"))
 *                 .build()))
 *         .description("an example Python Shell job")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.468Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.PythonShellExecutableProps")
@software.amazon.jsii.Jsii.Proxy(PythonShellExecutableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface PythonShellExecutableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Glue version.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/glue/latest/dg/release-notes.html">https://docs.aws.amazon.com/glue/latest/dg/release-notes.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.GlueVersion getGlueVersion();

    /**
     * (experimental) The Python version to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.PythonVersion getPythonVersion();

    /**
     * (experimental) The script that executes a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.Code getScript();

    /**
     * (experimental) Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
     * <p>
     * Only individual files are supported, directories are not supported.
     * <p>
     * Default: [] - no extra files are copied to the working directory
     * <p>
     * @see <a href="`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">`--extra-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.Code> getExtraFiles() {
        return null;
    }

    /**
     * (experimental) Additional Python files that AWS Glue adds to the Python path before executing your script.
     * <p>
     * Only individual files are supported, directories are not supported.
     * <p>
     * Default: - no extra python files and argument is not set
     * <p>
     * @see <a href="`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html">`--extra-py-files` in https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.glue.Code> getExtraPythonFiles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PythonShellExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PythonShellExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<PythonShellExecutableProps> {
        software.amazon.awscdk.services.glue.GlueVersion glueVersion;
        software.amazon.awscdk.services.glue.PythonVersion pythonVersion;
        software.amazon.awscdk.services.glue.Code script;
        java.util.List<software.amazon.awscdk.services.glue.Code> extraFiles;
        java.util.List<software.amazon.awscdk.services.glue.Code> extraPythonFiles;

        /**
         * Sets the value of {@link PythonShellExecutableProps#getGlueVersion}
         * @param glueVersion Glue version. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder glueVersion(software.amazon.awscdk.services.glue.GlueVersion glueVersion) {
            this.glueVersion = glueVersion;
            return this;
        }

        /**
         * Sets the value of {@link PythonShellExecutableProps#getPythonVersion}
         * @param pythonVersion The Python version to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pythonVersion(software.amazon.awscdk.services.glue.PythonVersion pythonVersion) {
            this.pythonVersion = pythonVersion;
            return this;
        }

        /**
         * Sets the value of {@link PythonShellExecutableProps#getScript}
         * @param script The script that executes a job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder script(software.amazon.awscdk.services.glue.Code script) {
            this.script = script;
            return this;
        }

        /**
         * Sets the value of {@link PythonShellExecutableProps#getExtraFiles}
         * @param extraFiles Additional files, such as configuration files that AWS Glue copies to the working directory of your script before executing it.
         *                   Only individual files are supported, directories are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraFiles(java.util.List<? extends software.amazon.awscdk.services.glue.Code> extraFiles) {
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.Code>)extraFiles;
            return this;
        }

        /**
         * Sets the value of {@link PythonShellExecutableProps#getExtraPythonFiles}
         * @param extraPythonFiles Additional Python files that AWS Glue adds to the Python path before executing your script.
         *                         Only individual files are supported, directories are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder extraPythonFiles(java.util.List<? extends software.amazon.awscdk.services.glue.Code> extraPythonFiles) {
            this.extraPythonFiles = (java.util.List<software.amazon.awscdk.services.glue.Code>)extraPythonFiles;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PythonShellExecutableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public PythonShellExecutableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PythonShellExecutableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PythonShellExecutableProps {
        private final software.amazon.awscdk.services.glue.GlueVersion glueVersion;
        private final software.amazon.awscdk.services.glue.PythonVersion pythonVersion;
        private final software.amazon.awscdk.services.glue.Code script;
        private final java.util.List<software.amazon.awscdk.services.glue.Code> extraFiles;
        private final java.util.List<software.amazon.awscdk.services.glue.Code> extraPythonFiles;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.glueVersion = software.amazon.jsii.Kernel.get(this, "glueVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.GlueVersion.class));
            this.pythonVersion = software.amazon.jsii.Kernel.get(this, "pythonVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.PythonVersion.class));
            this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Code.class));
            this.extraFiles = software.amazon.jsii.Kernel.get(this, "extraFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Code.class)));
            this.extraPythonFiles = software.amazon.jsii.Kernel.get(this, "extraPythonFiles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.Code.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.glueVersion = java.util.Objects.requireNonNull(builder.glueVersion, "glueVersion is required");
            this.pythonVersion = java.util.Objects.requireNonNull(builder.pythonVersion, "pythonVersion is required");
            this.script = java.util.Objects.requireNonNull(builder.script, "script is required");
            this.extraFiles = (java.util.List<software.amazon.awscdk.services.glue.Code>)builder.extraFiles;
            this.extraPythonFiles = (java.util.List<software.amazon.awscdk.services.glue.Code>)builder.extraPythonFiles;
        }

        @Override
        public final software.amazon.awscdk.services.glue.GlueVersion getGlueVersion() {
            return this.glueVersion;
        }

        @Override
        public final software.amazon.awscdk.services.glue.PythonVersion getPythonVersion() {
            return this.pythonVersion;
        }

        @Override
        public final software.amazon.awscdk.services.glue.Code getScript() {
            return this.script;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.Code> getExtraFiles() {
            return this.extraFiles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.glue.Code> getExtraPythonFiles() {
            return this.extraPythonFiles;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("glueVersion", om.valueToTree(this.getGlueVersion()));
            data.set("pythonVersion", om.valueToTree(this.getPythonVersion()));
            data.set("script", om.valueToTree(this.getScript()));
            if (this.getExtraFiles() != null) {
                data.set("extraFiles", om.valueToTree(this.getExtraFiles()));
            }
            if (this.getExtraPythonFiles() != null) {
                data.set("extraPythonFiles", om.valueToTree(this.getExtraPythonFiles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue.PythonShellExecutableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PythonShellExecutableProps.Jsii$Proxy that = (PythonShellExecutableProps.Jsii$Proxy) o;

            if (!glueVersion.equals(that.glueVersion)) return false;
            if (!pythonVersion.equals(that.pythonVersion)) return false;
            if (!script.equals(that.script)) return false;
            if (this.extraFiles != null ? !this.extraFiles.equals(that.extraFiles) : that.extraFiles != null) return false;
            return this.extraPythonFiles != null ? this.extraPythonFiles.equals(that.extraPythonFiles) : that.extraPythonFiles == null;
        }

        @Override
        public final int hashCode() {
            int result = this.glueVersion.hashCode();
            result = 31 * result + (this.pythonVersion.hashCode());
            result = 31 * result + (this.script.hashCode());
            result = 31 * result + (this.extraFiles != null ? this.extraFiles.hashCode() : 0);
            result = 31 * result + (this.extraPythonFiles != null ? this.extraPythonFiles.hashCode() : 0);
            return result;
        }
    }
}
