package software.amazon.awscdk.services.glue;

/**
 * (experimental) A security configuration is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 * <p>
 * The following scenarios show some of the ways that you can use a security configuration.
 * <p>
 * <ul>
 * <li>Attach a security configuration to an AWS Glue crawler to write encrypted Amazon CloudWatch Logs.</li>
 * <li>Attach a security configuration to an extract, transform, and load (ETL) job to write encrypted Amazon Simple Storage Service (Amazon S3) targets and encrypted CloudWatch Logs.</li>
 * <li>Attach a security configuration to an ETL job to write its jobs bookmarks as encrypted Amazon S3 data.</li>
 * <li>Attach a security configuration to a development endpoint to write encrypted Amazon S3 targets.</li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityConfiguration.Builder.create(this, "MySecurityConfiguration")
 *         .securityConfigurationName("name")
 *         .cloudWatchEncryption(CloudWatchEncryption.builder()
 *                 .mode(CloudWatchEncryptionMode.KMS)
 *                 .build())
 *         .jobBookmarksEncryption(JobBookmarksEncryption.builder()
 *                 .mode(JobBookmarksEncryptionMode.CLIENT_SIDE_KMS)
 *                 .build())
 *         .s3Encryption(S3Encryption.builder()
 *                 .mode(S3EncryptionMode.KMS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.476Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.SecurityConfiguration")
public class SecurityConfiguration extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.glue.ISecurityConfiguration {

    protected SecurityConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecurityConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public SecurityConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.SecurityConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Creates a Connection construct that represents an external security configuration.
     * <p>
     * @param scope The scope creating construct (usually `this`). This parameter is required.
     * @param id The construct's id. This parameter is required.
     * @param securityConfigurationName name of external security configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.ISecurityConfiguration fromSecurityConfigurationName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String securityConfigurationName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.SecurityConfiguration.class, "fromSecurityConfigurationName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.ISecurityConfiguration.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(securityConfigurationName, "securityConfigurationName is required") });
    }

    /**
     * (experimental) The name of the security configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityConfigurationName() {
        return software.amazon.jsii.Kernel.get(this, "securityConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The KMS key used in CloudWatch encryption if it requires a kms key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getCloudWatchEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (experimental) The KMS key used in job bookmarks encryption if it requires a kms key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getJobBookmarksEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "jobBookmarksEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (experimental) The KMS key used in S3 encryption if it requires a kms key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getS3EncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "s3EncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.glue.SecurityConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.SecurityConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.SecurityConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.SecurityConfigurationProps.Builder();
        }

        /**
         * (experimental) The name of the security configuration.
         * <p>
         * @return {@code this}
         * @param securityConfigurationName The name of the security configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfigurationName(final java.lang.String securityConfigurationName) {
            this.props.securityConfigurationName(securityConfigurationName);
            return this;
        }

        /**
         * (experimental) The encryption configuration for Amazon CloudWatch Logs.
         * <p>
         * Default: no cloudwatch logs encryption.
         * <p>
         * @return {@code this}
         * @param cloudWatchEncryption The encryption configuration for Amazon CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudWatchEncryption(final software.amazon.awscdk.services.glue.CloudWatchEncryption cloudWatchEncryption) {
            this.props.cloudWatchEncryption(cloudWatchEncryption);
            return this;
        }

        /**
         * (experimental) The encryption configuration for Glue Job Bookmarks.
         * <p>
         * Default: no job bookmarks encryption.
         * <p>
         * @return {@code this}
         * @param jobBookmarksEncryption The encryption configuration for Glue Job Bookmarks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobBookmarksEncryption(final software.amazon.awscdk.services.glue.JobBookmarksEncryption jobBookmarksEncryption) {
            this.props.jobBookmarksEncryption(jobBookmarksEncryption);
            return this;
        }

        /**
         * (experimental) The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * <p>
         * Default: no s3 encryption.
         * <p>
         * @return {@code this}
         * @param s3Encryption The encryption configuration for Amazon Simple Storage Service (Amazon S3) data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Encryption(final software.amazon.awscdk.services.glue.S3Encryption s3Encryption) {
            this.props.s3Encryption(s3Encryption);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.glue.SecurityConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.glue.SecurityConfiguration build() {
            return new software.amazon.awscdk.services.glue.SecurityConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
