package software.amazon.awscdk.services.glue;

/**
 * (experimental) Constructions properties of {@link SecurityConfiguration}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * SecurityConfiguration.Builder.create(this, "MySecurityConfiguration")
 *         .securityConfigurationName("name")
 *         .cloudWatchEncryption(CloudWatchEncryption.builder()
 *                 .mode(CloudWatchEncryptionMode.KMS)
 *                 .build())
 *         .jobBookmarksEncryption(JobBookmarksEncryption.builder()
 *                 .mode(JobBookmarksEncryptionMode.CLIENT_SIDE_KMS)
 *                 .build())
 *         .s3Encryption(S3Encryption.builder()
 *                 .mode(S3EncryptionMode.KMS)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.477Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.SecurityConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(SecurityConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface SecurityConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The name of the security configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityConfigurationName();

    /**
     * (experimental) The encryption configuration for Amazon CloudWatch Logs.
     * <p>
     * Default: no cloudwatch logs encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.CloudWatchEncryption getCloudWatchEncryption() {
        return null;
    }

    /**
     * (experimental) The encryption configuration for Glue Job Bookmarks.
     * <p>
     * Default: no job bookmarks encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.JobBookmarksEncryption getJobBookmarksEncryption() {
        return null;
    }

    /**
     * (experimental) The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
     * <p>
     * Default: no s3 encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.glue.S3Encryption getS3Encryption() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<SecurityConfigurationProps> {
        java.lang.String securityConfigurationName;
        software.amazon.awscdk.services.glue.CloudWatchEncryption cloudWatchEncryption;
        software.amazon.awscdk.services.glue.JobBookmarksEncryption jobBookmarksEncryption;
        software.amazon.awscdk.services.glue.S3Encryption s3Encryption;

        /**
         * Sets the value of {@link SecurityConfigurationProps#getSecurityConfigurationName}
         * @param securityConfigurationName The name of the security configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityConfigurationName(java.lang.String securityConfigurationName) {
            this.securityConfigurationName = securityConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getCloudWatchEncryption}
         * @param cloudWatchEncryption The encryption configuration for Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cloudWatchEncryption(software.amazon.awscdk.services.glue.CloudWatchEncryption cloudWatchEncryption) {
            this.cloudWatchEncryption = cloudWatchEncryption;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getJobBookmarksEncryption}
         * @param jobBookmarksEncryption The encryption configuration for Glue Job Bookmarks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder jobBookmarksEncryption(software.amazon.awscdk.services.glue.JobBookmarksEncryption jobBookmarksEncryption) {
            this.jobBookmarksEncryption = jobBookmarksEncryption;
            return this;
        }

        /**
         * Sets the value of {@link SecurityConfigurationProps#getS3Encryption}
         * @param s3Encryption The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder s3Encryption(software.amazon.awscdk.services.glue.S3Encryption s3Encryption) {
            this.s3Encryption = s3Encryption;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecurityConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public SecurityConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SecurityConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecurityConfigurationProps {
        private final java.lang.String securityConfigurationName;
        private final software.amazon.awscdk.services.glue.CloudWatchEncryption cloudWatchEncryption;
        private final software.amazon.awscdk.services.glue.JobBookmarksEncryption jobBookmarksEncryption;
        private final software.amazon.awscdk.services.glue.S3Encryption s3Encryption;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.securityConfigurationName = software.amazon.jsii.Kernel.get(this, "securityConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cloudWatchEncryption = software.amazon.jsii.Kernel.get(this, "cloudWatchEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.CloudWatchEncryption.class));
            this.jobBookmarksEncryption = software.amazon.jsii.Kernel.get(this, "jobBookmarksEncryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.JobBookmarksEncryption.class));
            this.s3Encryption = software.amazon.jsii.Kernel.get(this, "s3Encryption", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.S3Encryption.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.securityConfigurationName = java.util.Objects.requireNonNull(builder.securityConfigurationName, "securityConfigurationName is required");
            this.cloudWatchEncryption = builder.cloudWatchEncryption;
            this.jobBookmarksEncryption = builder.jobBookmarksEncryption;
            this.s3Encryption = builder.s3Encryption;
        }

        @Override
        public final java.lang.String getSecurityConfigurationName() {
            return this.securityConfigurationName;
        }

        @Override
        public final software.amazon.awscdk.services.glue.CloudWatchEncryption getCloudWatchEncryption() {
            return this.cloudWatchEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.glue.JobBookmarksEncryption getJobBookmarksEncryption() {
            return this.jobBookmarksEncryption;
        }

        @Override
        public final software.amazon.awscdk.services.glue.S3Encryption getS3Encryption() {
            return this.s3Encryption;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("securityConfigurationName", om.valueToTree(this.getSecurityConfigurationName()));
            if (this.getCloudWatchEncryption() != null) {
                data.set("cloudWatchEncryption", om.valueToTree(this.getCloudWatchEncryption()));
            }
            if (this.getJobBookmarksEncryption() != null) {
                data.set("jobBookmarksEncryption", om.valueToTree(this.getJobBookmarksEncryption()));
            }
            if (this.getS3Encryption() != null) {
                data.set("s3Encryption", om.valueToTree(this.getS3Encryption()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-glue.SecurityConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecurityConfigurationProps.Jsii$Proxy that = (SecurityConfigurationProps.Jsii$Proxy) o;

            if (!securityConfigurationName.equals(that.securityConfigurationName)) return false;
            if (this.cloudWatchEncryption != null ? !this.cloudWatchEncryption.equals(that.cloudWatchEncryption) : that.cloudWatchEncryption != null) return false;
            if (this.jobBookmarksEncryption != null ? !this.jobBookmarksEncryption.equals(that.jobBookmarksEncryption) : that.jobBookmarksEncryption != null) return false;
            return this.s3Encryption != null ? this.s3Encryption.equals(that.s3Encryption) : that.s3Encryption == null;
        }

        @Override
        public final int hashCode() {
            int result = this.securityConfigurationName.hashCode();
            result = 31 * result + (this.cloudWatchEncryption != null ? this.cloudWatchEncryption.hashCode() : 0);
            result = 31 * result + (this.jobBookmarksEncryption != null ? this.jobBookmarksEncryption.hashCode() : 0);
            result = 31 * result + (this.s3Encryption != null ? this.s3Encryption.hashCode() : 0);
            return result;
        }
    }
}
