package software.amazon.awscdk.services.glue;

/**
 * (experimental) The type of predefined worker that is allocated when a job runs.
 * <p>
 * If you need to use a WorkerType that doesn't exist as a static member, you
 * can instantiate a <code>WorkerType</code> object, e.g: <code>WorkerType.of('other type')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * WorkerType workerType = WorkerType.G_1X;
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:43.506Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.glue.$Module.class, fqn = "@aws-cdk/aws-glue.WorkerType")
public class WorkerType extends software.amazon.jsii.JsiiObject {

    protected WorkerType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WorkerType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        G_1_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.WorkerType.class, "G_1X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.WorkerType.class));
        G_2_X = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.WorkerType.class, "G_2X", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.WorkerType.class));
        STANDARD = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.WorkerType.class, "STANDARD", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.WorkerType.class));
    }

    /**
     * (experimental) Custom worker type.
     * <p>
     * @param workerType custom worker type. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.WorkerType of(final @org.jetbrains.annotations.NotNull java.lang.String workerType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.glue.WorkerType.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.glue.WorkerType.class), new Object[] { java.util.Objects.requireNonNull(workerType, "workerType is required") });
    }

    /**
     * (experimental) Each worker maps to 1 DPU (4 vCPU, 16 GB of memory, 64 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.WorkerType G_1_X;

    /**
     * (experimental) Each worker maps to 2 DPU (8 vCPU, 32 GB of memory, 128 GB disk), and provides 1 executor per worker.
     * <p>
     * Suitable for memory-intensive jobs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.WorkerType G_2_X;

    /**
     * (experimental) Each worker provides 4 vCPU, 16 GB of memory and a 50GB disk, and 2 executors per worker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public final static software.amazon.awscdk.services.glue.WorkerType STANDARD;

    /**
     * (experimental) The name of this WorkerType, as expected by Job resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
