/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.glue.;
import software.amazon.awscdk.services.glue.Column;
import software.amazon.awscdk.services.glue.DataFormat;
import software.amazon.awscdk.services.glue.IDatabase;
import software.amazon.awscdk.services.glue.PartitionIndex;
import software.amazon.awscdk.services.glue.TableEncryption;
import software.amazon.awscdk.services.glue.TableProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-glue.TableProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface TableProps
extends JsiiSerializable {
    @NotNull
    public List<Column> getColumns();

    @NotNull
    public IDatabase getDatabase();

    @NotNull
    public DataFormat getDataFormat();

    @NotNull
    public String getTableName();

    @Nullable
    default public IBucket getBucket() {
        return null;
    }

    @Nullable
    default public Boolean getCompressed() {
        return null;
    }

    @Nullable
    default public String getDescription() {
        return null;
    }

    @Nullable
    default public TableEncryption getEncryption() {
        return null;
    }

    @Nullable
    default public IKey getEncryptionKey() {
        return null;
    }

    @Nullable
    default public List<PartitionIndex> getPartitionIndexes() {
        return null;
    }

    @Nullable
    default public List<Column> getPartitionKeys() {
        return null;
    }

    @Nullable
    default public String getS3Prefix() {
        return null;
    }

    @Nullable
    default public Boolean getStoredAsSubDirectories() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TableProps> {
        List<Column> columns;
        IDatabase database;
        DataFormat dataFormat;
        String tableName;
        IBucket bucket;
        Boolean compressed;
        String description;
        TableEncryption encryption;
        IKey encryptionKey;
        List<PartitionIndex> partitionIndexes;
        List<Column> partitionKeys;
        String s3Prefix;
        Boolean storedAsSubDirectories;

        public Builder columns(List<? extends Column> columns) {
            this.columns = columns;
            return this;
        }

        public Builder database(IDatabase database) {
            this.database = database;
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder bucket(IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder compressed(Boolean compressed) {
            this.compressed = compressed;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder encryption(TableEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder partitionIndexes(List<? extends PartitionIndex> partitionIndexes) {
            this.partitionIndexes = partitionIndexes;
            return this;
        }

        public Builder partitionKeys(List<? extends Column> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public Builder storedAsSubDirectories(Boolean storedAsSubDirectories) {
            this.storedAsSubDirectories = storedAsSubDirectories;
            return this;
        }

        public TableProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

