/**
 * <h1>AWS Glue Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * All classes with the <code>Cfn</code> prefix in this module (<a href="https://docs.aws.amazon.com/cdk/latest/guide/constructs.html#constructs_lib">CFN Resources</a>) are always stable and safe to use.
 * <p>
 * </blockquote>
 * <p>
 * <img alt="cdk-constructs: Experimental" src="https://img.shields.io/badge/cdk--constructs-experimental-important.svg?style=for-the-badge">
 * <p>
 * <blockquote>
 * <p>
 * The APIs of higher level constructs in this module are experimental and under active development.
 * They are subject to non-backward compatible changes or removal in any future version. These are
 * not subject to the <a href="https://semver.org/">Semantic Versioning</a> model and breaking changes will be
 * announced in the release notes. This means that while you may use them, you may need to update
 * your source code when upgrading to a newer version of this package.
 * <p>
 * </blockquote>
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>Connection</h2>
 * <p>
 * A <code>Connection</code> allows Glue jobs, crawlers and development endpoints to access certain types of data stores. For example, to create a network connection to connect to a data source within a VPC:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Connection.Builder.create(stack, "MyConnection")
 *         .connectionType(glue.ConnectionTypes.getNETWORK())
 *         // The security groups granting AWS Glue inbound access to the data source within the VPC
 *         .securityGroups(asList(securityGroup))
 *         // The VPC subnet which contains the data source
 *         .subnet(subnet)
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you need to use a connection type that doesn't exist as a static member on <code>ConnectionType</code>, you can instantiate a <code>ConnectionType</code> object, e.g: <code>new glue.ConnectionType('NEW_TYPE')</code>.
 * <p>
 * See <a href="https://docs.aws.amazon.com/glue/latest/dg/populate-add-connection.html">Adding a Connection to Your Data Store</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-Connection">Connection Structure</a> documentation for more information on the supported data stores and their configurations.
 * <p>
 * <h2>Database</h2>
 * <p>
 * A <code>Database</code> is a logical grouping of <code>Tables</code> in the Glue Catalog.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Database.Builder.create(stack, "MyDatabase")
 *         .databaseName("my_database")
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>SecurityConfiguration</h2>
 * <p>
 * A <code>SecurityConfiguration</code> is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * SecurityConfiguration.Builder.create(stack, "MySecurityConfiguration")
 *         .securityConfigurationName("name")
 *         .cloudWatchEncryption(Map.of(
 *                 "mode", glue.CloudWatchEncryptionMode.getKMS()))
 *         .jobBookmarksEncryption(Map.of(
 *                 "mode", glue.JobBookmarksEncryptionMode.getCLIENT_SIDE_KMS()))
 *         .s3Encryption(Map.of(
 *                 "mode", glue.S3EncryptionMode.getKMS()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default, a shared KMS key is created for use with the encryption configurations that require one. You can also supply your own key for each encryption config, for example, for CloudWatch encryption:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * SecurityConfiguration.Builder.create(stack, "MySecurityConfiguration")
 *         .securityConfigurationName("name")
 *         .cloudWatchEncryption(Map.of(
 *                 "mode", glue.CloudWatchEncryptionMode.getKMS(),
 *                 "kmsKey", key))
 *         .build();
 * </pre></blockquote>
 * <p>
 * See <a href="https://docs.aws.amazon.com/glue/latest/dg/encryption-security-configuration.html">documentation</a> for more info for Glue encrypting data written by Crawlers, Jobs, and Development Endpoints.
 * <p>
 * <h2>Table</h2>
 * <p>
 * A Glue table describes a table of data in S3: its structure (column names and types), location of data (S3 objects with a common prefix in a S3 bucket), and format for the files (Json, Avro, Parquet, etc.):
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(asList(Map.of(
 *                 "name", "col1",
 *                 "type", glue.Schema.getSTRING()), Map.of(
 *                 "name", "col2",
 *                 "type", glue.Schema.array(Schema.getSTRING()),
 *                 "comment", "col2 is an array of strings")))
 *         .dataFormat(glue.DataFormat.getJSON())
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default, a S3 bucket will be created to store the table's data but you can manually pass the <code>bucket</code> and <code>s3Prefix</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .bucket(myBucket)
 *         .s3Prefix("my-table/")...
 *         .build();
 * </pre></blockquote>
 * <p>
 * By default, an S3 bucket will be created to store the table's data and stored in the bucket root. You can also manually pass the <code>bucket</code> and <code>s3Prefix</code>:
 * <p>
 * <h3>Partitions</h3>
 * <p>
 * To improve query performance, a table can specify <code>partitionKeys</code> on which data is stored and queried separately. For example, you might partition a table by <code>year</code> and <code>month</code> to optimize queries based on a time window:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .database(myDatabase)
 *         .tableName("my_table")
 *         .columns(asList(Map.of(
 *                 "name", "col1",
 *                 "type", glue.Schema.getSTRING())))
 *         .partitionKeys(asList(Map.of(
 *                 "name", "year",
 *                 "type", glue.Schema.getSMALL_INT()), Map.of(
 *                 "name", "month",
 *                 "type", glue.Schema.getSMALL_INT())))
 *         .dataFormat(glue.DataFormat.getJSON())
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2><a href="https://docs.aws.amazon.com/athena/latest/ug/encryption.html">Encryption</a></h2>
 * <p>
 * You can enable encryption on a Table's data:
 * <p>
 * <ul>
 * <li><code>Unencrypted</code> - files are not encrypted. The default encryption setting.</li>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">S3Managed</a> - Server side encryption (<code>SSE-S3</code>) with an Amazon S3-managed key.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getS3_MANAGED())...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">Kms</a> - Server-side encryption (<code>SSE-KMS</code>) with an AWS KMS Key managed by the account owner.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // KMS key is created automatically
 * // KMS key is created automatically
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getKMS())...
 *         .build();
 * 
 * // with an explicit KMS key
 * // with an explicit KMS key
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getKMS())
 *         .encryptionKey(new Key(stack, "MyKey"))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">KmsManaged</a> - Server-side encryption (<code>SSE-KMS</code>), like <code>Kms</code>, except with an AWS KMS Key managed by the AWS Key Management Service.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getKMS_MANAGED())...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html#client-side-encryption-kms-managed-master-key-intro">ClientSideKms</a> - Client-side encryption (<code>CSE-KMS</code>) with an AWS KMS Key managed by the account owner.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // KMS key is created automatically
 * // KMS key is created automatically
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getCLIENT_SIDE_KMS())...
 *         .build();
 * 
 * // with an explicit KMS key
 * // with an explicit KMS key
 * Table.Builder.create(stack, "MyTable")
 *         .encryption(glue.TableEncryption.getCLIENT_SIDE_KMS())
 *         .encryptionKey(new Key(stack, "MyKey"))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <em>Note: you cannot provide a <code>Bucket</code> when creating the <code>Table</code> if you wish to use server-side encryption (<code>KMS</code>, <code>KMS_MANAGED</code> or <code>S3_MANAGED</code>)</em>.
 * <p>
 * <h2>Types</h2>
 * <p>
 * A table's schema is a collection of columns, each of which have a <code>name</code> and a <code>type</code>. Types are recursive structures, consisting of primitive and complex types:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Table.Builder.create(stack, "MyTable")
 *         .columns(asList(Map.of(
 *                 "name", "primitive_column",
 *                 "type", glue.Schema.getSTRING()), Map.of(
 *                 "name", "array_column",
 *                 "type", glue.Schema.array(glue.Schema.getINTEGER()),
 *                 "comment", "array&lt;integer&gt;"), Map.of(
 *                 "name", "map_column",
 *                 "type", glue.Schema.map(glue.Schema.getSTRING(), glue.Schema.getTIMESTAMP()),
 *                 "comment", "map&lt;string,string&gt;"), Map.of(
 *                 "name", "struct_column",
 *                 "type", glue.Schema.struct(asList(Map.of(
 *                         "name", "nested_column",
 *                         "type", glue.Schema.getDATE(),
 *                         "comment", "nested comment"))),
 *                 "comment", "struct&lt;nested_column:date COMMENT 'nested comment'&gt;")))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Primitives</h3>
 * <p>
 * <h4>Numeric</h4>
 * <p>
 * | Name      	| Type     	| Comments                                                                                                          |
 * |-----------	|----------	|------------------------------------------------------------------------------------------------------------------	|
 * | FLOAT     	| Constant 	| A 32-bit single-precision floating point number                                                                   |
 * | INTEGER   	| Constant 	| A 32-bit signed value in two's complement format, with a minimum value of -2^31 and a maximum value of 2^31-1 	|
 * | DOUBLE    	| Constant 	| A 64-bit double-precision floating point number                                                                   |
 * | BIG_INT   	| Constant 	| A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63 -1  |
 * | SMALL_INT 	| Constant 	| A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1   |
 * | TINY_INT  	| Constant 	| A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1      |
 * <p>
 * <h4>Date and time</h4>
 * <p>
 * | Name      	| Type     	| Comments                                                                                                                                                                	|
 * |-----------	|----------	|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------	|
 * | DATE      	| Constant 	| A date in UNIX format, such as YYYY-MM-DD.                                                                                                                              	|
 * | TIMESTAMP 	| Constant 	| Date and time instant in the UNiX format, such as yyyy-mm-dd hh:mm:ss[.f...]. For example, TIMESTAMP '2008-09-15 03:04:05.324'. This format uses the session time zone. 	|
 * <p>
 * <h4>String</h4>
 * <p>
 * | Name                                       	| Type     	| Comments                                                                                                                                                                                          	|
 * |--------------------------------------------	|----------	|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------	|
 * | STRING                                     	| Constant 	| A string literal enclosed in single or double quotes                                                                                                                                              	|
 * | decimal(precision: number, scale?: number) 	| Function 	| <code>precision</code> is the total number of digits. <code>scale</code> (optional) is the number of digits in fractional part with a default of 0. For example, use these type definitions: decimal(11,5), decimal(15) 	|
 * | char(length: number)                       	| Function 	| Fixed length character data, with a specified length between 1 and 255, such as char(10)                                                                                                          	|
 * | varchar(length: number)                    	| Function 	| Variable length character data, with a specified length between 1 and 65535, such as varchar(10)                                                                                                  	|
 * <p>
 * <h4>Miscellaneous</h4>
 * <p>
 * | Name    	| Type     	| Comments                      	|
 * |---------	|----------	|-------------------------------	|
 * | BOOLEAN 	| Constant 	| Values are <code>true</code> and <code>false</code> 	|
 * | BINARY  	| Constant 	| Value is in binary            	|
 * <p>
 * <h3>Complex</h3>
 * <p>
 * | Name                                	| Type     	| Comments                                                          	|
 * |-------------------------------------	|----------	|-------------------------------------------------------------------	|
 * | array(itemType: Type)               	| Function 	| An array of some other type                                       	|
 * | map(keyType: Type, valueType: Type) 	| Function 	| A map of some primitive key type to any value type                	|
 * | struct(collumns: Column[])          	| Function 	| Nested structure containing individually named and typed collumns 	|
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.amazon.awscdk.services.glue;
