/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.greengrass;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.greengrass.;
import software.amazon.awscdk.services.greengrass.CfnResourceDefinition;
import software.amazon.awscdk.services.greengrass.CfnResourceDefinitionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition")
public class CfnResourceDefinition
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnResourceDefinition.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnResourceDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnResourceDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnResourceDefinition(@NotNull Construct scope, @NotNull String id, @NotNull CfnResourceDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLatestVersionArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrLatestVersionArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)((Object)this), (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)((Object)this), (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public Object getInitialVersion() {
        return Kernel.get((Object)((Object)this), (String)"initialVersion", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInitialVersion(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"initialVersion", (Object)value);
    }

    public void setInitialVersion(@Nullable ResourceDefinitionVersionProperty value) {
        Kernel.set((Object)((Object)this), (String)"initialVersion", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnResourceDefinition> {
        private final Construct scope;
        private final String id;
        private final CfnResourceDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnResourceDefinitionProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder initialVersion(IResolvable initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        public Builder initialVersion(ResourceDefinitionVersionProperty initialVersion) {
            this.props.initialVersion(initialVersion);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnResourceDefinition build() {
            return new CfnResourceDefinition(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.SecretsManagerSecretResourceDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecretsManagerSecretResourceDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getArn();

        @Nullable
        default public List<String> getAdditionalStagingLabelsToDownload() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecretsManagerSecretResourceDataProperty> {
            private String arn;
            private List<String> additionalStagingLabelsToDownload;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public Builder additionalStagingLabelsToDownload(List<String> additionalStagingLabelsToDownload) {
                this.additionalStagingLabelsToDownload = additionalStagingLabelsToDownload;
                return this;
            }

            public SecretsManagerSecretResourceDataProperty build() {
                return new Jsii.Proxy(this.arn, this.additionalStagingLabelsToDownload);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.SageMakerMachineLearningModelResourceDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SageMakerMachineLearningModelResourceDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestinationPath();

        @NotNull
        public String getSageMakerJobArn();

        @Nullable
        default public Object getOwnerSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SageMakerMachineLearningModelResourceDataProperty> {
            private String destinationPath;
            private String sageMakerJobArn;
            private Object ownerSetting;

            public Builder destinationPath(String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            public Builder sageMakerJobArn(String sageMakerJobArn) {
                this.sageMakerJobArn = sageMakerJobArn;
                return this;
            }

            public Builder ownerSetting(IResolvable ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            public Builder ownerSetting(ResourceDownloadOwnerSettingProperty ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            public SageMakerMachineLearningModelResourceDataProperty build() {
                return new Jsii.Proxy(this.destinationPath, this.sageMakerJobArn, this.ownerSetting);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.S3MachineLearningModelResourceDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3MachineLearningModelResourceDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestinationPath();

        @NotNull
        public String getS3Uri();

        @Nullable
        default public Object getOwnerSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3MachineLearningModelResourceDataProperty> {
            private String destinationPath;
            private String s3Uri;
            private Object ownerSetting;

            public Builder destinationPath(String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder ownerSetting(IResolvable ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            public Builder ownerSetting(ResourceDownloadOwnerSettingProperty ownerSetting) {
                this.ownerSetting = ownerSetting;
                return this;
            }

            public S3MachineLearningModelResourceDataProperty build() {
                return new Jsii.Proxy(this.destinationPath, this.s3Uri, this.ownerSetting);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.ResourceInstanceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceInstanceProperty
    extends JsiiSerializable {
        @NotNull
        public String getId();

        @NotNull
        public String getName();

        @NotNull
        public Object getResourceDataContainer();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceInstanceProperty> {
            private String id;
            private String name;
            private Object resourceDataContainer;

            public Builder id(String id) {
                this.id = id;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder resourceDataContainer(IResolvable resourceDataContainer) {
                this.resourceDataContainer = resourceDataContainer;
                return this;
            }

            public Builder resourceDataContainer(ResourceDataContainerProperty resourceDataContainer) {
                this.resourceDataContainer = resourceDataContainer;
                return this;
            }

            public ResourceInstanceProperty build() {
                return new Jsii.Proxy(this.id, this.name, this.resourceDataContainer);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.ResourceDownloadOwnerSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceDownloadOwnerSettingProperty
    extends JsiiSerializable {
        @NotNull
        public String getGroupOwner();

        @NotNull
        public String getGroupPermission();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceDownloadOwnerSettingProperty> {
            private String groupOwner;
            private String groupPermission;

            public Builder groupOwner(String groupOwner) {
                this.groupOwner = groupOwner;
                return this;
            }

            public Builder groupPermission(String groupPermission) {
                this.groupPermission = groupPermission;
                return this;
            }

            public ResourceDownloadOwnerSettingProperty build() {
                return new Jsii.Proxy(this.groupOwner, this.groupPermission);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.ResourceDefinitionVersionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceDefinitionVersionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getResources();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceDefinitionVersionProperty> {
            private Object resources;

            public Builder resources(IResolvable resources) {
                this.resources = resources;
                return this;
            }

            public Builder resources(List<? extends Object> resources) {
                this.resources = resources;
                return this;
            }

            public ResourceDefinitionVersionProperty build() {
                return new Jsii.Proxy(this.resources);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.ResourceDataContainerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceDataContainerProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLocalDeviceResourceData() {
            return null;
        }

        @Nullable
        default public Object getLocalVolumeResourceData() {
            return null;
        }

        @Nullable
        default public Object getS3MachineLearningModelResourceData() {
            return null;
        }

        @Nullable
        default public Object getSageMakerMachineLearningModelResourceData() {
            return null;
        }

        @Nullable
        default public Object getSecretsManagerSecretResourceData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceDataContainerProperty> {
            private Object localDeviceResourceData;
            private Object localVolumeResourceData;
            private Object s3MachineLearningModelResourceData;
            private Object sageMakerMachineLearningModelResourceData;
            private Object secretsManagerSecretResourceData;

            public Builder localDeviceResourceData(IResolvable localDeviceResourceData) {
                this.localDeviceResourceData = localDeviceResourceData;
                return this;
            }

            public Builder localDeviceResourceData(LocalDeviceResourceDataProperty localDeviceResourceData) {
                this.localDeviceResourceData = localDeviceResourceData;
                return this;
            }

            public Builder localVolumeResourceData(IResolvable localVolumeResourceData) {
                this.localVolumeResourceData = localVolumeResourceData;
                return this;
            }

            public Builder localVolumeResourceData(LocalVolumeResourceDataProperty localVolumeResourceData) {
                this.localVolumeResourceData = localVolumeResourceData;
                return this;
            }

            public Builder s3MachineLearningModelResourceData(IResolvable s3MachineLearningModelResourceData) {
                this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
                return this;
            }

            public Builder s3MachineLearningModelResourceData(S3MachineLearningModelResourceDataProperty s3MachineLearningModelResourceData) {
                this.s3MachineLearningModelResourceData = s3MachineLearningModelResourceData;
                return this;
            }

            public Builder sageMakerMachineLearningModelResourceData(IResolvable sageMakerMachineLearningModelResourceData) {
                this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
                return this;
            }

            public Builder sageMakerMachineLearningModelResourceData(SageMakerMachineLearningModelResourceDataProperty sageMakerMachineLearningModelResourceData) {
                this.sageMakerMachineLearningModelResourceData = sageMakerMachineLearningModelResourceData;
                return this;
            }

            public Builder secretsManagerSecretResourceData(IResolvable secretsManagerSecretResourceData) {
                this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
                return this;
            }

            public Builder secretsManagerSecretResourceData(SecretsManagerSecretResourceDataProperty secretsManagerSecretResourceData) {
                this.secretsManagerSecretResourceData = secretsManagerSecretResourceData;
                return this;
            }

            public ResourceDataContainerProperty build() {
                return new Jsii.Proxy(this.localDeviceResourceData, this.localVolumeResourceData, this.s3MachineLearningModelResourceData, this.sageMakerMachineLearningModelResourceData, this.secretsManagerSecretResourceData);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.LocalVolumeResourceDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocalVolumeResourceDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getDestinationPath();

        @NotNull
        public String getSourcePath();

        @Nullable
        default public Object getGroupOwnerSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocalVolumeResourceDataProperty> {
            private String destinationPath;
            private String sourcePath;
            private Object groupOwnerSetting;

            public Builder destinationPath(String destinationPath) {
                this.destinationPath = destinationPath;
                return this;
            }

            public Builder sourcePath(String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            public Builder groupOwnerSetting(IResolvable groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            public Builder groupOwnerSetting(GroupOwnerSettingProperty groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            public LocalVolumeResourceDataProperty build() {
                return new Jsii.Proxy(this.destinationPath, this.sourcePath, this.groupOwnerSetting);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.LocalDeviceResourceDataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LocalDeviceResourceDataProperty
    extends JsiiSerializable {
        @NotNull
        public String getSourcePath();

        @Nullable
        default public Object getGroupOwnerSetting() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LocalDeviceResourceDataProperty> {
            private String sourcePath;
            private Object groupOwnerSetting;

            public Builder sourcePath(String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            public Builder groupOwnerSetting(IResolvable groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            public Builder groupOwnerSetting(GroupOwnerSettingProperty groupOwnerSetting) {
                this.groupOwnerSetting = groupOwnerSetting;
                return this;
            }

            public LocalDeviceResourceDataProperty build() {
                return new Jsii.Proxy(this.sourcePath, this.groupOwnerSetting);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-greengrass.CfnResourceDefinition.GroupOwnerSettingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GroupOwnerSettingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getAutoAddGroupOwner();

        @Nullable
        default public String getGroupOwner() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GroupOwnerSettingProperty> {
            private Object autoAddGroupOwner;
            private String groupOwner;

            public Builder autoAddGroupOwner(Boolean autoAddGroupOwner) {
                this.autoAddGroupOwner = autoAddGroupOwner;
                return this;
            }

            public Builder autoAddGroupOwner(IResolvable autoAddGroupOwner) {
                this.autoAddGroupOwner = autoAddGroupOwner;
                return this;
            }

            public Builder groupOwner(String groupOwner) {
                this.groupOwner = groupOwner;
                return this;
            }

            public GroupOwnerSettingProperty build() {
                return new Jsii.Proxy(this.autoAddGroupOwner, this.groupOwner);
            }
        }
    }
}

