package software.amazon.awscdk.services.guardduty;

/**
 * Properties for defining a `CfnFilter`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * Object criterion;
 * CfnFilterProps cfnFilterProps = CfnFilterProps.builder()
 *         .action("action")
 *         .description("description")
 *         .detectorId("detectorId")
 *         .findingCriteria(FindingCriteriaProperty.builder()
 *                 .criterion(criterion)
 *                 .itemType(ConditionProperty.builder()
 *                         .eq(List.of("eq"))
 *                         .equalTo(List.of("equalTo"))
 *                         .greaterThan(123)
 *                         .greaterThanOrEqual(123)
 *                         .gt(123)
 *                         .gte(123)
 *                         .lessThan(123)
 *                         .lessThanOrEqual(123)
 *                         .lt(123)
 *                         .lte(123)
 *                         .neq(List.of("neq"))
 *                         .notEquals(List.of("notEquals"))
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .rank(123)
 *         // the properties below are optional
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.71.0 (build f1f58ae)", date = "2022-12-07T17:24:35.411Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.guardduty.$Module.class, fqn = "@aws-cdk/aws-guardduty.CfnFilterProps")
@software.amazon.jsii.Jsii.Proxy(CfnFilterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFilterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAction();

    /**
     * The description of the filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The ID of the detector belonging to the GuardDuty account that you want to create a filter for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * Represents the criteria to be used in the filter for querying findings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getFindingCriteria();

    /**
     * The name of the filter.
     * <p>
     * Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the position of the filter in the list of current filters.
     * <p>
     * Also specifies the order in which this filter is applied to the findings.
     * <p>
     * <blockquote>
     * <p>
     * By default, filters may not be created in the same order as they are ranked. To ensure filters are created in the correct order, you can use the optional <code>DependsOn</code> attribute with the following syntax: <code>"DependsOn":[ "ObjectName" ]</code> . You can find more information on using this attribute <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">here</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRank();

    /**
     * The tags to be added to a new filter resource.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFilterProps> {
        java.lang.String action;
        java.lang.String description;
        java.lang.String detectorId;
        java.lang.Object findingCriteria;
        java.lang.String name;
        java.lang.Number rank;
        java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFilterProps#getAction}
         * @param action Specifies the action that is to be applied to the findings that match the filter. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getDescription}
         * @param description The description of the filter. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getDetectorId}
         * @param detectorId The ID of the detector belonging to the GuardDuty account that you want to create a filter for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getFindingCriteria}
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(software.amazon.awscdk.core.IResolvable findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getFindingCriteria}
         * @param findingCriteria Represents the criteria to be used in the filter for querying findings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder findingCriteria(software.amazon.awscdk.services.guardduty.CfnFilter.FindingCriteriaProperty findingCriteria) {
            this.findingCriteria = findingCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getName}
         * @param name The name of the filter. This parameter is required.
         *             Minimum length of 3. Maximum length of 64. Valid characters include alphanumeric characters, dot (.), underscore (_), and dash (-). Spaces are not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getRank}
         * @param rank Specifies the position of the filter in the list of current filters. This parameter is required.
         *             Also specifies the order in which this filter is applied to the findings.
         *             <p>
         *             <blockquote>
         *             <p>
         *             By default, filters may not be created in the same order as they are ranked. To ensure filters are created in the correct order, you can use the optional <code>DependsOn</code> attribute with the following syntax: <code>"DependsOn":[ "ObjectName" ]</code> . You can find more information on using this attribute <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">here</a> .
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rank(java.lang.Number rank) {
            this.rank = rank;
            return this;
        }

        /**
         * Sets the value of {@link CfnFilterProps#getTags}
         * @param tags The tags to be added to a new filter resource.
         *             Each tag consists of a key and an optional value, both of which you define.
         *             <p>
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFilterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFilterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFilterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFilterProps {
        private final java.lang.String action;
        private final java.lang.String description;
        private final java.lang.String detectorId;
        private final java.lang.Object findingCriteria;
        private final java.lang.String name;
        private final java.lang.Number rank;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.findingCriteria = software.amazon.jsii.Kernel.get(this, "findingCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rank = software.amazon.jsii.Kernel.get(this, "rank", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.findingCriteria = java.util.Objects.requireNonNull(builder.findingCriteria, "findingCriteria is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.rank = java.util.Objects.requireNonNull(builder.rank, "rank is required");
            this.tags = (java.util.List<software.amazon.awscdk.core.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAction() {
            return this.action;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.Object getFindingCriteria() {
            return this.findingCriteria;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getRank() {
            return this.rank;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("action", om.valueToTree(this.getAction()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("findingCriteria", om.valueToTree(this.getFindingCriteria()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("rank", om.valueToTree(this.getRank()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-guardduty.CfnFilterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFilterProps.Jsii$Proxy that = (CfnFilterProps.Jsii$Proxy) o;

            if (!action.equals(that.action)) return false;
            if (!description.equals(that.description)) return false;
            if (!detectorId.equals(that.detectorId)) return false;
            if (!findingCriteria.equals(that.findingCriteria)) return false;
            if (!name.equals(that.name)) return false;
            if (!rank.equals(that.rank)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.action.hashCode();
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.detectorId.hashCode());
            result = 31 * result + (this.findingCriteria.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.rank.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
