package software.amazon.awscdk.services.iam;

/**
 * An IAM role that only gets attached to the construct tree once it gets used, not before
 * 
 * This construct can be used to simplify logic in other constructs
 * which need to create a role but only if certain configurations occur
 * (such as when AutoScaling is configured). The role can be configured in one
 * place, but if it never gets used it doesn't get instantiated and will
 * not be synthesized or deployed.
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.8 (build 100f5ad)", date = "2018-11-08T13:03:45.668Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.iam.$Module.class, fqn = "@aws-cdk/aws-iam.LazyRole")
public class LazyRole extends software.amazon.awscdk.Construct implements software.amazon.awscdk.services.iam.IRole {
    protected LazyRole(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    public LazyRole(final software.amazon.awscdk.Construct parent, final java.lang.String id, final software.amazon.awscdk.services.iam.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(id, "id is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(props, "props is required"))).toArray());
    }

    /**
     * Adds a permission to the role's default policy document.
     * If there is no default policy attached to this role, it will be created.
     */
    @Override
    public void addToPolicy(final software.amazon.awscdk.services.iam.PolicyStatement statement) {
        this.jsiiCall("addToPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(statement, "statement is required")).toArray());
    }

    /**
     * Attaches a policy to this role.
     * @param policy The policy to attach
     */
    @Override
    public void attachInlinePolicy(final software.amazon.awscdk.services.iam.Policy policy) {
        this.jsiiCall("attachInlinePolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(policy, "policy is required")).toArray());
    }

    /**
     * Attaches a managed policy to this role.
     * @param arn The ARN of the managed policy to attach.
     */
    @Override
    public void attachManagedPolicy(final java.lang.String arn) {
        this.jsiiCall("attachManagedPolicy", Void.class, java.util.stream.Stream.of(java.util.Objects.requireNonNull(arn, "arn is required")).toArray());
    }

    /**
     * Returns the role.
     */
    @Override
    public java.util.List<software.amazon.awscdk.IDependable> getDependencyElements() {
        return this.jsiiGet("dependencyElements", java.util.List.class);
    }

    /**
     * Returns a Principal object representing the ARN of this role.
     */
    @Override
    public software.amazon.awscdk.services.iam.PolicyPrincipal getPrincipal() {
        return this.jsiiGet("principal", software.amazon.awscdk.services.iam.PolicyPrincipal.class);
    }

    public software.amazon.awscdk.services.iam.RoleProps getProps() {
        return this.jsiiGet("props", software.amazon.awscdk.services.iam.RoleProps.class);
    }

    /**
     * Returns the ARN of this role.
     */
    @Override
    public java.lang.String getRoleArn() {
        return this.jsiiGet("roleArn", java.lang.String.class);
    }
}
