package software.amazon.awscdk.services.iam;

@javax.annotation.Generated(value = "jsii-pacmak/0.7.11 (build 44c3b9b)", date = "2018-12-04T12:16:30.357Z")
public interface PolicyProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     */
    java.util.List<software.amazon.awscdk.services.iam.Group> getGroups();
    /**
     * Groups to attach this policy to.
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     */
    void setGroups(final java.util.List<software.amazon.awscdk.services.iam.Group> value);
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
     */
    java.lang.String getPolicyName();
    /**
     * The name of the policy. If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
     */
    void setPolicyName(final java.lang.String value);
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     */
    java.util.List<software.amazon.awscdk.services.iam.Role> getRoles();
    /**
     * Roles to attach this policy to.
     * You can also use `attachToRole(role)` to attach this policy to a role.
     */
    void setRoles(final java.util.List<software.amazon.awscdk.services.iam.Role> value);
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     */
    java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements();
    /**
     * Initial set of permissions to add to this policy document.
     * You can also use `addPermission(statement)` to add permissions later.
     */
    void setStatements(final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value);
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     */
    java.util.List<software.amazon.awscdk.services.iam.User> getUsers();
    /**
     * Users to attach this policy to.
     * You can also use `attachToUser(user)` to attach this policy to a user.
     */
    void setUsers(final java.util.List<software.amazon.awscdk.services.iam.User> value);

    /**
     * @return a {@link Builder} of {@link PolicyProps}
     */
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link PolicyProps}
     */
    final class Builder {
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.Group> _groups;
        @javax.annotation.Nullable
        private java.lang.String _policyName;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.Role> _roles;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> _statements;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.iam.User> _users;

        /**
         * Sets the value of Groups
         * @param value Groups to attach this policy to.
You can also use `attachToGroup(group)` to attach this policy to a group.
         * @return {@code this}
         */
        public Builder withGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this._groups = value;
            return this;
        }
        /**
         * Sets the value of PolicyName
         * @param value The name of the policy. If you specify multiple policies for an entity,
specify unique names. For example, if you specify a list of policies for
an IAM role, each policy must have a unique name.
         * @return {@code this}
         */
        public Builder withPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this._policyName = value;
            return this;
        }
        /**
         * Sets the value of Roles
         * @param value Roles to attach this policy to.
You can also use `attachToRole(role)` to attach this policy to a role.
         * @return {@code this}
         */
        public Builder withRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
            this._roles = value;
            return this;
        }
        /**
         * Sets the value of Statements
         * @param value Initial set of permissions to add to this policy document.
You can also use `addPermission(statement)` to add permissions later.
         * @return {@code this}
         */
        public Builder withStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this._statements = value;
            return this;
        }
        /**
         * Sets the value of Users
         * @param value Users to attach this policy to.
You can also use `attachToUser(user)` to attach this policy to a user.
         * @return {@code this}
         */
        public Builder withUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this._users = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        public PolicyProps build() {
            return new PolicyProps() {
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.iam.Group> $groups = _groups;
                @javax.annotation.Nullable
                private java.lang.String $policyName = _policyName;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.iam.Role> $roles = _roles;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> $statements = _statements;
                @javax.annotation.Nullable
                private java.util.List<software.amazon.awscdk.services.iam.User> $users = _users;

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
                    return this.$groups;
                }

                @Override
                public void setGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
                    this.$groups = value;
                }

                @Override
                public java.lang.String getPolicyName() {
                    return this.$policyName;
                }

                @Override
                public void setPolicyName(@javax.annotation.Nullable final java.lang.String value) {
                    this.$policyName = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.Role> getRoles() {
                    return this.$roles;
                }

                @Override
                public void setRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
                    this.$roles = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
                    return this.$statements;
                }

                @Override
                public void setStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
                    this.$statements = value;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
                    return this.$users;
                }

                @Override
                public void setUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.User> value) {
                    this.$users = value;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.iam.PolicyProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Group> getGroups() {
            return this.jsiiGet("groups", java.util.List.class);
        }

        /**
         * Groups to attach this policy to.
         * You can also use `attachToGroup(group)` to attach this policy to a group.
         */
        @Override
        public void setGroups(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Group> value) {
            this.jsiiSet("groups", value);
        }

        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        @Override
        @javax.annotation.Nullable
        public java.lang.String getPolicyName() {
            return this.jsiiGet("policyName", java.lang.String.class);
        }

        /**
         * The name of the policy. If you specify multiple policies for an entity,
         * specify unique names. For example, if you specify a list of policies for
         * an IAM role, each policy must have a unique name.
         * @default Uses the logical ID of the policy resource, which is ensured to be unique within the stack.
         */
        @Override
        public void setPolicyName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("policyName", value);
        }

        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.Role> getRoles() {
            return this.jsiiGet("roles", java.util.List.class);
        }

        /**
         * Roles to attach this policy to.
         * You can also use `attachToRole(role)` to attach this policy to a role.
         */
        @Override
        public void setRoles(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.Role> value) {
            this.jsiiSet("roles", value);
        }

        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.jsiiGet("statements", java.util.List.class);
        }

        /**
         * Initial set of permissions to add to this policy document.
         * You can also use `addPermission(statement)` to add permissions later.
         */
        @Override
        public void setStatements(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> value) {
            this.jsiiSet("statements", value);
        }

        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        @Override
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.iam.User> getUsers() {
            return this.jsiiGet("users", java.util.List.class);
        }

        /**
         * Users to attach this policy to.
         * You can also use `attachToUser(user)` to attach this policy to a user.
         */
        @Override
        public void setUsers(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.iam.User> value) {
            this.jsiiSet("users", value);
        }
    }
}
